/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory.inventory;

import com.cleanroommc.modularui.factory.inventory.InventoryVisitor;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public abstract class InventoryType {
    private static final Map<String, InventoryType> inventoryTypes = new Object2ObjectOpenHashMap();
    private final String id;

    public InventoryType(String id) {
        this.id = id;
        if (this.isActive()) {
            inventoryTypes.put(id, this);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isActive() {
        return true;
    }

    public abstract ItemStack getStackInSlot(EntityPlayer var1, int var2);

    public abstract void setStackInSlot(EntityPlayer var1, int var2, ItemStack var3);

    public abstract int getSlotCount(EntityPlayer var1);

    public int findFirstStackable(EntityPlayer player, ItemStack stack) {
        int n = this.getSlotCount(player);
        for (int i = 0; i < n; ++i) {
            ItemStack stackInSlot = this.getStackInSlot(player, i);
            if (!(Platform.isStackEmpty(stackInSlot) ? Platform.isStackEmpty(stack) : ItemHandlerHelper.canItemStacksStack(stackInSlot, stack))) continue;
            return i;
        }
        return -1;
    }

    public boolean visitAllStackable(EntityPlayer player, ItemStack stack, InventoryVisitor visitor) {
        int n = this.getSlotCount(player);
        for (int i = 0; i < n; ++i) {
            ItemStack stackInSlot = this.getStackInSlot(player, i);
            if (!(Platform.isStackEmpty(stackInSlot) ? Platform.isStackEmpty(stack) && visitor.visit(this, i, stackInSlot) : ItemHandlerHelper.canItemStacksStack(stackInSlot, stack) && visitor.visit(this, i, stackInSlot))) continue;
            return true;
        }
        return false;
    }

    public boolean visitAll(EntityPlayer player, InventoryVisitor visitor) {
        int n = this.getSlotCount(player);
        for (int i = 0; i < n; ++i) {
            ItemStack stackInSlot = this.getStackInSlot(player, i);
            if (!visitor.visit(this, i, stackInSlot)) continue;
            return true;
        }
        return false;
    }

    public void write(PacketBuffer buf) {
        NetworkUtils.writeStringSafe(buf, this.id);
    }

    public static InventoryType read(PacketBuffer buf) {
        return InventoryType.getFromId(NetworkUtils.readStringSafe(buf));
    }

    public static InventoryType getFromId(String id) {
        return inventoryTypes.get(id);
    }

    public static Collection<InventoryType> getAll() {
        return Collections.unmodifiableCollection(inventoryTypes.values());
    }
}

