/*
 * Decompiled with CFR 0.152.
 */
package tb.common.item;

import DummyCore.Utils.Pair;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tb.api.RevolverUpgrade;
import tb.common.entity.EntityRevolverBullet;
import tb.core.TBCore;
import tb.network.proxy.TBNetworkManager;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IWarpingGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.codechicken.lib.math.MathHelper;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.ConfigBlocks;

public class ItemRevolver
extends Item
implements IRepairable,
IWarpingGear {
    public static void addUpgrade(ItemStack stk, RevolverUpgrade upgrade, int level) {
        if (stk.func_77942_o() && stk.func_77978_p().func_74764_b("tb.upgrades")) {
            NBTTagList upgrades = stk.func_77978_p().func_150295_c("tb.upgrades", 10);
            for (int i = 0; i < upgrades.func_74745_c(); ++i) {
                NBTTagCompound tag = upgrades.func_150305_b(i);
                int id = tag.func_74762_e("id");
                int llevel = tag.func_74762_e("level");
                if (upgrade.id != id) continue;
                llevel = level;
                tag.func_74768_a("level", llevel);
                return;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("id", upgrade.id);
            tag.func_74768_a("level", level);
            upgrades.func_74742_a((NBTBase)tag);
        } else {
            if (!stk.func_77942_o()) {
                stk.func_77982_d(new NBTTagCompound());
            }
            if (!stk.func_77978_p().func_74764_b("tb.upgrades")) {
                stk.func_77978_p().func_74782_a("tb.upgrades", (NBTBase)new NBTTagList());
            }
            ItemRevolver.addUpgrade(stk, upgrade, level);
        }
    }

    public static int getUpgradeLevel(ItemStack stk, RevolverUpgrade upgrade) {
        if (stk.func_77942_o() && stk.func_77978_p().func_74764_b("tb.upgrades")) {
            NBTTagList upgrades = stk.func_77978_p().func_150295_c("tb.upgrades", 10);
            for (int i = 0; i < upgrades.func_74745_c(); ++i) {
                NBTTagCompound tag = upgrades.func_150305_b(i);
                int id = tag.func_74762_e("id");
                int level = tag.func_74762_e("level");
                if (id >= RevolverUpgrade.allUpgrades.length || RevolverUpgrade.allUpgrades[id] == null || !RevolverUpgrade.allUpgrades[id].equals(upgrade)) continue;
                return level;
            }
        }
        return 0;
    }

    public static ArrayList<Pair<RevolverUpgrade, Integer>> getAllUpgradesFor(ItemStack stk) {
        ArrayList<Pair<RevolverUpgrade, Integer>> retLst = new ArrayList<Pair<RevolverUpgrade, Integer>>();
        if (stk.func_77942_o() && stk.func_77978_p().func_74764_b("tb.upgrades")) {
            NBTTagList upgrades = stk.func_77978_p().func_150295_c("tb.upgrades", 10);
            for (int i = 0; i < upgrades.func_74745_c(); ++i) {
                NBTTagCompound tag = upgrades.func_150305_b(i);
                int id = tag.func_74762_e("id");
                int level = tag.func_74762_e("level");
                if (id >= RevolverUpgrade.allUpgrades.length || RevolverUpgrade.allUpgrades[id] == null) continue;
                retLst.add((Pair<RevolverUpgrade, Integer>)new Pair((Object)RevolverUpgrade.allUpgrades[id], (Object)level));
            }
        }
        return retLst;
    }

    public boolean func_77644_a(ItemStack stk, EntityLivingBase attacker, EntityLivingBase attacked) {
        stk.func_77972_a(2, attacked);
        return true;
    }

    public ItemStack func_77659_a(ItemStack stk, World w, EntityPlayer user) {
        if (w.field_72995_K) {
            return stk;
        }
        if (!stk.func_77942_o()) {
            stk.func_77982_d(new NBTTagCompound());
        }
        if (stk.func_77978_p().func_74762_e("shots") > 0) {
            EntityRevolverBullet b = new EntityRevolverBullet(w, (EntityLivingBase)user);
            if (!w.field_72995_K) {
                w.func_72838_d((Entity)b);
            }
            stk.func_77972_a(1, (EntityLivingBase)user);
            if (stk == null || stk.func_77960_j() > stk.func_77958_k()) {
                return null;
            }
            TBNetworkManager.playSoundOnServer(w, "thaumicbases:revolver.shot", user.field_70165_t, user.field_70163_u, user.field_70161_v, 3.0f, 1.0f);
            stk.func_77978_p().func_74780_a("barrelRotation", stk.func_77978_p().func_74769_h("barrelRotation") + 45.0);
            stk.func_77978_p().func_74768_a("shots", stk.func_77978_p().func_74762_e("shots") - 1);
        } else if (stk.func_77942_o() && stk.func_77978_p().func_74764_b("jar")) {
            boolean bl;
            ItemStack jar = ItemStack.func_77949_a((NBTTagCompound)stk.field_77990_d.func_74775_l("jar"));
            if (jar == null) {
                TBNetworkManager.playSoundOnServer(w, "thaumicbases:revolver.click", user.field_70165_t, user.field_70163_u, user.field_70161_v, 3.0f, 2.0f);
                stk.func_77978_p().func_74780_a("barrelRotation", stk.func_77978_p().func_74769_h("barrelRotation") + 45.0);
                return super.func_77659_a(stk, w, user);
            }
            ArrayList<Pair<RevolverUpgrade, Integer>> upgrades = ItemRevolver.getAllUpgradesFor(stk);
            boolean hasPrimal = false;
            for (Pair<RevolverUpgrade, Integer> pair : upgrades) {
                if (pair.getFirst() == RevolverUpgrade.primal) {
                    hasPrimal = true;
                }
                if (!hasPrimal) continue;
                break;
            }
            int addedShots = hasPrimal ? 1 : 2;
            for (Pair<RevolverUpgrade, Integer> pair : upgrades) {
                addedShots = ((RevolverUpgrade)pair.getFirst()).modifyShots(user, stk, (Integer)pair.getSecond(), addedShots, hasPrimal);
            }
            boolean bl2 = false;
            if (!(jar.func_77973_b() instanceof ItemJarFilled)) {
                return super.func_77659_a(stk, w, user);
            }
            AspectList aspectList = ((ItemJarFilled)jar.func_77973_b()).getAspects(jar);
            if (aspectList != null && aspectList.size() > 0) {
                for (Aspect tag : aspectList.getAspectsSorted()) {
                    int required;
                    if (tag != Aspect.WEAPON) continue;
                    int n = required = addedShots < 0 ? 2 : 1;
                    if (aspectList.getAmount(tag) < required) continue;
                    aspectList.reduce(tag, required);
                    bl = true;
                    break;
                }
            }
            if (bl) {
                stk.func_77978_p().func_74768_a("shots", addedShots < 0 ? 1 : addedShots);
                TBNetworkManager.playSoundOnServer(w, "thaumicbases:revolver.reload", user.field_70165_t, user.field_70163_u, user.field_70161_v, 3.0f, 2.0f);
            }
            if (aspectList.visSize() > 0) {
                ((ItemJarFilled)jar.func_77973_b()).setAspects(jar, aspectList);
                NBTTagCompound tag = new NBTTagCompound();
                jar.func_77955_b(tag);
                stk.func_77983_a("jar", (NBTBase)tag);
            } else {
                ItemStack emptyJar = new ItemStack(ConfigBlocks.blockJar, 1, 0);
                NBTTagCompound tag = new NBTTagCompound();
                emptyJar.func_77955_b(tag);
                stk.func_77983_a("jar", (NBTBase)tag);
            }
        } else {
            TBNetworkManager.playSoundOnServer(w, "thaumicbases:revolver.click", user.field_70165_t, user.field_70163_u, user.field_70161_v, 3.0f, 2.0f);
        }
        return super.func_77659_a(stk, w, user);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof EntityPlayer && ((EntityPlayer)EntityPlayer.class.cast((Object)entityLiving)).field_71070_bA instanceof ContainerPlayer && entityLiving.func_70093_af()) {
            ((EntityPlayer)EntityPlayer.class.cast(entityLiving)).openGui((Object)TBCore.instance, 4331801, entityLiving.field_70170_p, MathHelper.floor_double((double)entityLiving.field_70165_t), MathHelper.floor_double((double)entityLiving.field_70163_u), MathHelper.floor_double((double)entityLiving.field_70161_v));
        }
        return false;
    }

    public void func_77624_a(ItemStack stk, EntityPlayer p, List lst, boolean isCurrentItem) {
        super.func_77624_a(stk, p, lst, isCurrentItem);
        if (stk.func_77942_o() && stk.func_77978_p().func_74764_b("jar")) {
            ItemStack jar = ItemStack.func_77949_a((NBTTagCompound)stk.field_77990_d.func_74775_l("jar"));
            try {
                AspectList aspects;
                if (jar.func_77973_b() instanceof ItemJarFilled && (aspects = ((ItemJarFilled)jar.func_77973_b()).getAspects(jar)) != null && aspects.size() > 0) {
                    for (Aspect tag : aspects.getAspectsSorted()) {
                        if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(p.func_70005_c_(), tag)) {
                            lst.add(tag.getName() + " x " + aspects.getAmount(tag));
                            continue;
                        }
                        lst.add(StatCollector.func_74838_a((String)"tc.aspect.unknown"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stk.func_77942_o() && stk.func_77978_p().func_74764_b("tb.upgrades")) {
            ArrayList<Pair<RevolverUpgrade, Integer>> upgrades = ItemRevolver.getAllUpgradesFor(stk);
            for (Pair<RevolverUpgrade, Integer> pr : upgrades) {
                lst.add(((RevolverUpgrade)pr.getFirst()).getName() + " " + StatCollector.func_74838_a((String)("enchantment.level." + pr.getSecond())));
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stk) {
        return EnumRarity.rare;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap retMap = HashMultimap.create();
        retMap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(5.0f + (float)(ItemRevolver.getUpgradeLevel(stack, RevolverUpgrade.heavy) * 2)), 0));
        return retMap;
    }

    public void func_77663_a(ItemStack stk, World w, Entity entity, int slot, boolean held) {
        super.func_77663_a(stk, w, entity, slot, held);
        int u = ItemRevolver.getUpgradeLevel(stk, RevolverUpgrade.uvoid);
        if (u > 0 && stk.func_77951_h() && entity != null && entity.field_70173_aa % 100 / u == 0 && entity instanceof EntityLivingBase) {
            stk.func_77972_a(-1, (EntityLivingBase)entity);
        }
        if (stk.func_77978_p() != null) {
            double rotation = stk.func_77978_p().func_74769_h("barrelRotation");
            double renderedRotation = stk.func_77978_p().func_74769_h("renderedRotation");
            if (rotation >= 3600000.0) {
                rotation -= 3600000.0;
            }
            if (renderedRotation >= 3600000.0) {
                renderedRotation -= 3600000.0;
            }
            if (renderedRotation < rotation) {
                renderedRotation += 10.0;
            }
            renderedRotation = Math.min(rotation, renderedRotation);
            stk.func_77978_p().func_74780_a("barrelRotation", rotation);
            stk.func_77978_p().func_74780_a("renderedRotation", renderedRotation);
        }
    }

    public int getWarp(ItemStack stk, EntityPlayer player) {
        return ItemRevolver.getUpgradeLevel(stk, RevolverUpgrade.uvoid);
    }
}

