/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.network;

import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.lang.ref.WeakReference;
import java.util.List;
import net.glease.tc4tweak.TC4Tweak;

@ChannelHandler.Sharable
public class IndexedCodec
extends MessageToMessageCodec<FMLProxyPacket, IMessage> {
    private final TByteObjectMap<Class<? extends IMessage>> discriminators = new TByteObjectHashMap();
    private final TObjectByteMap<Class<? extends IMessage>> types = new TObjectByteHashMap();

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(FMLIndexedMessageToMessageCodec.INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public IndexedCodec addDiscriminator(int discriminator, Class<? extends IMessage> type) {
        this.discriminators.put((byte)discriminator, type);
        this.types.put(type, (byte)discriminator);
        return this;
    }

    protected final void encode(ChannelHandlerContext ctx, IMessage msg, List<Object> out) throws Exception {
        FMLProxyPacket old;
        ByteBuf buffer = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        byte discriminator = this.types.get(clazz);
        buffer.writeByte((int)discriminator);
        msg.toBytes(buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(FMLIndexedMessageToMessageCodec.INBOUNDPACKETTRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)ref.get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    protected final void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class clazz = (Class)this.discriminators.get(discriminator);
        if (clazz == null) {
            TC4Tweak.log.warn("Undefined message: {}. Is server running a newer TC4Tweaks?", new Object[]{discriminator});
            return;
        }
        IMessage newMsg = (IMessage)clazz.newInstance();
        ((ThreadLocal)ctx.attr(FMLIndexedMessageToMessageCodec.INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
        newMsg.fromBytes(payload);
        out.add(newMsg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        TC4Tweak.log.error("IndexedCodec exception caught", cause);
        super.exceptionCaught(ctx, cause);
    }
}

