/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.alchemy;

import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipe;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AlchemyRecipeRegistry {
    public static List<AlchemyRecipe> recipes = new ArrayList<AlchemyRecipe>();

    public static void registerRecipe(ItemStack output, int amountNeeded, ItemStack[] recipe, int bloodOrbLevel) {
        recipes.add(new AlchemyRecipe(output, amountNeeded, recipe, bloodOrbLevel));
    }

    public static ItemStack getResult(ItemStack[] recipe, ItemStack bloodOrb) {
        if (bloodOrb == null) {
            return null;
        }
        if (!(bloodOrb.func_77973_b() instanceof IBloodOrb)) {
            return null;
        }
        int bloodOrbLevel = ((IBloodOrb)bloodOrb.func_77973_b()).getOrbLevel();
        for (AlchemyRecipe ar : recipes) {
            if (!ar.doesRecipeMatch(recipe, bloodOrbLevel)) continue;
            return ar.getResult();
        }
        return null;
    }

    public static int getAmountNeeded(ItemStack[] recipe, ItemStack bloodOrb) {
        if (bloodOrb == null) {
            return 0;
        }
        if (!(bloodOrb.func_77973_b() instanceof IBloodOrb)) {
            return 0;
        }
        int bloodOrbLevel = ((IBloodOrb)bloodOrb.func_77973_b()).getOrbLevel();
        for (AlchemyRecipe ar : recipes) {
            if (!ar.doesRecipeMatch(recipe, bloodOrbLevel)) continue;
            return ar.getAmountNeeded();
        }
        return 0;
    }

    public static ItemStack[] getRecipeForItemStack(ItemStack itemStack) {
        for (AlchemyRecipe ar : recipes) {
            ItemStack result = ar.getResult();
            if (result == null || !result.func_77969_a(itemStack)) continue;
            return ar.getRecipe();
        }
        return null;
    }
}

