/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.Log;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.teleport.TravelController;
import crazypants.util.BaublesUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraftforge.common.MinecraftForge;

public class PacketTravelEvent
implements IMessage,
IMessageHandler<PacketTravelEvent, IMessage> {
    int x;
    int y;
    int z;
    int powerUse;
    boolean conserveMotion;
    int entityId;
    int source;

    public PacketTravelEvent() {
    }

    public PacketTravelEvent(Entity entity, int x, int y, int z, int powerUse, boolean conserveMotion, TravelSource source) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.powerUse = powerUse;
        this.conserveMotion = conserveMotion;
        this.entityId = entity instanceof EntityPlayer ? -1 : entity.func_145782_y();
        this.source = source.ordinal();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.powerUse);
        buf.writeBoolean(this.conserveMotion);
        buf.writeInt(this.entityId);
        buf.writeInt(this.source);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.powerUse = buf.readInt();
        this.conserveMotion = buf.readBoolean();
        this.entityId = buf.readInt();
        this.source = buf.readInt();
    }

    public IMessage onMessage(PacketTravelEvent message, MessageContext ctx) {
        if (message.entityId != -1) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to illegally tp other entity {}.", new Object[]{ctx.getServerHandler().field_147369_b.func_146103_bH(), message.entityId});
            return null;
        }
        EntityPlayerMP toTp = ctx.getServerHandler().field_147369_b;
        int x = message.x;
        int y = message.y;
        int z = message.z;
        TravelSource source = TravelSource.values()[message.source];
        String error = TravelController.instance.validatePacketTravelEvent(toTp, x, y, z, message.powerUse, message.conserveMotion, source);
        if (error != null) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to tp without valid prereq: {}", new Object[]{ctx.getServerHandler().field_147369_b.func_146103_bH(), error});
            return null;
        }
        PacketTravelEvent.doServerTeleport((Entity)toTp, x, y, z, message.powerUse, message.conserveMotion, source);
        return null;
    }

    public static boolean doServerTeleport(Entity toTp, int x, int y, int z, int powerUse, boolean conserveMotion, TravelSource source) {
        EntityPlayer player = toTp instanceof EntityPlayer ? (EntityPlayer)toTp : null;
        TeleportEntityEvent evt = new TeleportEntityEvent(toTp, source, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        x = evt.targetX;
        y = evt.targetY;
        z = evt.targetZ;
        toTp.field_70170_p.func_72908_a(toTp.field_70165_t, toTp.field_70163_u, toTp.field_70161_v, source.sound, 1.0f, 1.0f);
        toTp.func_85030_a(source.sound, 1.0f, 1.0f);
        if (player != null) {
            player.func_70634_a((double)x + 0.5, (double)y + 0.1, (double)z + 0.5);
        } else {
            toTp.func_70107_b((double)x, (double)y, (double)z);
        }
        toTp.field_70170_p.func_72908_a((double)x, (double)y, (double)z, source.sound, 1.0f, 1.0f);
        toTp.field_70143_R = 0.0f;
        if (player != null) {
            if (conserveMotion) {
                Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
                S12PacketEntityVelocity p = new S12PacketEntityVelocity(player.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)p);
            }
            ItemStack travelItem = player.func_71045_bC();
            int itemSlot = -1;
            if (travelItem == null || travelItem.func_77973_b() == null || !(travelItem.func_77973_b() instanceof IItemOfTravel)) {
                travelItem = TravelController.instance.findTravelItemInInventoryOrBaubles(player);
                itemSlot = TravelController.instance.findTravelItemSlotInInventoryOrBaubles(player);
            }
            if (powerUse > 0 && travelItem != null && travelItem.func_77973_b() instanceof IItemOfTravel) {
                ItemStack item = travelItem.func_77946_l();
                ((IItemOfTravel)item.func_77973_b()).extractInternal(item, powerUse);
                if (itemSlot == -1) {
                    player.func_70062_b(0, item);
                } else if (itemSlot > -1) {
                    player.field_71071_by.func_70299_a(itemSlot, item);
                } else if (itemSlot < -1) {
                    int baubleSlot = Math.abs(itemSlot) - 2;
                    IInventory baubles = BaublesUtil.instance().getBaubles(player);
                    baubles.func_70299_a(baubleSlot, item);
                }
            }
        }
        return true;
    }
}

