/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.PlayerUtil;
import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.CompositeInventory;
import crazypants.enderio.machine.hypercube.HyperCubeRegister;
import crazypants.enderio.machine.hypercube.ItemRecieveBuffer;
import crazypants.enderio.machine.hypercube.PacketStoredPower;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.IInternalPowerHandler;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileHyperCube
extends TileEntityEio
implements IInternalPowerHandler,
IFluidHandler,
ISidedInventory,
IRedstoneModeControlable {
    private static final double ENERGY_LOSS = Config.transceiverEnergyLoss;
    private static final int ENERGY_UPKEEP = Config.transceiverUpkeepCostRF;
    private static final float MILLIBUCKET_TRANSMISSION_COST = (float)Config.transceiverBucketTransmissionCostRF / 1000.0f;
    private final BasicCapacitor internalCapacitor = new BasicCapacitor(Config.transceiverMaxIoRF, 25000);
    private int lastSyncPowerStored = 0;
    private int storedEnergyRF;
    private final List<Receptor> receptors = new ArrayList<Receptor>();
    private ListIterator<Receptor> receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private final List<NetworkFluidHandler> fluidHandlers = new ArrayList<NetworkFluidHandler>();
    private boolean fluidHandlersDirty = true;
    private CompositeInventory localInventory = new CompositeInventory();
    private boolean inventoriesDirty = true;
    private Channel channel = null;
    private Channel registeredChannel = null;
    private UUID owner;
    private boolean init = true;
    private float milliBucketsTransfered = 0.0f;
    private EnumMap<SubChannel, IoMode> ioModes = new EnumMap(SubChannel.class);
    private ItemRecieveBuffer recieveBuffer;
    protected RedstoneControlMode redstoneControlMode = RedstoneControlMode.IGNORE;
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    private boolean isConnected = false;

    public TileHyperCube() {
        this.recieveBuffer = new ItemRecieveBuffer(this);
    }

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    public IoMode getModeForChannel(SubChannel channel) {
        IoMode mode = this.ioModes.get((Object)channel);
        if (mode == null) {
            return IoMode.NEITHER;
        }
        return mode;
    }

    public void setModeForChannel(SubChannel channel, IoMode mode) {
        this.ioModes.put(channel, mode);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    int getEnergyStoredScaled(int scale) {
        return (int)VecmathUtil.clamp((double)Math.round((double)scale * ((double)this.getEnergyStored() / (double)this.getMaxEnergyStored())), (double)0.0, (double)scale);
    }

    public void onBreakBlock() {
        HyperCubeRegister.instance.deregister(this);
    }

    public void onBlockAdded() {
        HyperCubeRegister.instance.register(this);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    private boolean canMaintainConnection() {
        if (this.channel == null || HyperCubeRegister.instance == null || !this.redstoneCheckPassed) {
            return false;
        }
        List<TileHyperCube> cons = HyperCubeRegister.instance.getCubesForChannel(this.channel);
        for (TileHyperCube cube : cons) {
            if (cube == this || cube.getEnergyStored() > 0) continue;
            return false;
        }
        return cons != null && cons.size() > 1 && this.getEnergyStored() > 0;
    }

    private void sendEnergyToOtherNodes() {
        List<TileHyperCube> cubes = HyperCubeRegister.instance.getCubesForChannel(this.channel);
        if (cubes == null || cubes.isEmpty()) {
            return;
        }
        if (this.canSendPower()) {
            for (TileHyperCube cube : cubes) {
                int stored = this.getEnergyStored();
                if (stored <= 0 || cube == null || cube == this || !cube.canRecievePower()) continue;
                int curPower = cube.getEnergyStored();
                int requires = cube.getMaxEnergyStored() - curPower;
                int transfer = Math.min(requires, stored);
                transfer = Math.min(transfer, Config.transceiverMaxIoRF);
                cube.setEnergyStored(curPower + (int)Math.round((1.0 - ENERGY_LOSS) * (double)transfer));
                this.setEnergyStored(this.getEnergyStored() - transfer);
            }
        }
    }

    public void onChunkUnload() {
        if (HyperCubeRegister.instance != null) {
            HyperCubeRegister.instance.deregister(this);
        }
        this.fluidHandlersDirty = true;
        this.receptorsDirty = true;
        this.inventoriesDirty = true;
    }

    public void onNeighborBlockChange() {
        this.receptorsDirty = true;
        this.fluidHandlersDirty = true;
        this.inventoriesDirty = true;
        this.redstoneStateDirty = true;
        this.updateInventories();
    }

    public void doUpdate() {
        boolean powerChanged;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.storedEnergyRF -= ENERGY_UPKEEP;
        this.storedEnergyRF = (int)((float)this.storedEnergyRF - MILLIBUCKET_TRANSMISSION_COST * this.milliBucketsTransfered);
        this.storedEnergyRF = Math.max(this.storedEnergyRF, 0);
        this.milliBucketsTransfered = 0.0f;
        boolean prevRedCheck = this.redstoneCheckPassed;
        if (this.redstoneStateDirty) {
            this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
            this.redstoneStateDirty = false;
        }
        if (!this.redstoneCheckPassed && this.registeredChannel != null) {
            HyperCubeRegister.instance.deregister(this, this.registeredChannel);
            this.registeredChannel = null;
        }
        if (this.storedEnergyRF > 0) {
            this.transmitEnergy();
            this.sendEnergyToOtherNodes();
        }
        this.updateInventories();
        this.pushRecieveBuffer();
        boolean requiresClientSync = false;
        boolean stillConnected = this.canMaintainConnection();
        if (this.isConnected != stillConnected) {
            this.fluidHandlersDirty = true;
            this.isConnected = stillConnected;
            requiresClientSync = true;
        }
        this.updateFluidHandlers();
        if (this.redstoneCheckPassed && (this.registeredChannel == null ? this.channel != null : !this.registeredChannel.equals(this.channel))) {
            if (this.registeredChannel != null) {
                HyperCubeRegister.instance.deregister(this, this.registeredChannel);
            }
            HyperCubeRegister.instance.register(this);
            this.registeredChannel = this.channel;
        }
        requiresClientSync |= prevRedCheck != this.redstoneCheckPassed;
        boolean bl = powerChanged = this.lastSyncPowerStored != this.storedEnergyRF && this.shouldDoWorkThisTick(21);
        if (powerChanged) {
            this.lastSyncPowerStored = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketStoredPower(this), (TileEntity)this);
        }
        if (requiresClientSync) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    private boolean canSendFluid() {
        return this.getModeForChannel(SubChannel.FLUID).isSendEnabled();
    }

    private boolean canSendPower() {
        return this.getModeForChannel(SubChannel.POWER).isSendEnabled();
    }

    private boolean canSendItems() {
        return this.getModeForChannel(SubChannel.ITEM).isSendEnabled() && this.redstoneCheckPassed;
    }

    private boolean canRecieveFluid() {
        return this.getModeForChannel(SubChannel.FLUID).isRecieveEnabled();
    }

    private boolean canRecievePower() {
        return this.getModeForChannel(SubChannel.POWER).isRecieveEnabled();
    }

    private boolean canRecieveItems() {
        return this.getModeForChannel(SubChannel.ITEM).isRecieveEnabled();
    }

    private boolean transmitEnergy() {
        if (!this.getModeForChannel(SubChannel.POWER).isRecieveEnabled() || !this.redstoneCheckPassed || this.getEnergyStored() <= 0) {
            return false;
        }
        int canTransmit = Math.min(this.getEnergyStored(), this.internalCapacitor.getMaxEnergyExtracted());
        int transmitted = 0;
        this.updatePowersReceptors();
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0 && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = this.receptorIterator.next();
            IPowerInterface pp = receptor.receptor;
            if (pp != null && pp.getMinEnergyReceived(receptor.fromDir.getOpposite()) <= canTransmit) {
                float used = pp.recieveEnergy(receptor.fromDir.getOpposite(), canTransmit);
                transmitted = (int)((float)transmitted + used);
                canTransmit = (int)((float)canTransmit - used);
            }
            if (canTransmit <= 0) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getModeForChannel(SubChannel.POWER) != IoMode.RECIEVE) {
            return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storedEnergyRF;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        if (this.getModeForChannel(SubChannel.POWER) == IoMode.RECIEVE) {
            return 0;
        }
        return this.internalCapacitor.getMaxEnergyReceived();
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.internalCapacitor.getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canSendFluid()) {
            return 0;
        }
        FluidStack in = resource.copy();
        int result = 0;
        for (NetworkFluidHandler h : this.getNetworkHandlers()) {
            if (!h.node.canRecieveFluid() || !h.handler.canFill(h.dirOp, in.getFluid())) continue;
            int filled = h.handler.fill(h.dirOp, in, doFill);
            in.amount -= filled;
            result += filled;
        }
        if (doFill) {
            this.milliBucketsTransfered += (float)result;
        }
        return result;
    }

    private void updatePowersReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        BlockCoord myLoc = new BlockCoord((TileEntity)this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord checkLoc = myLoc.getLocation(dir);
            TileEntity te = this.field_145850_b.func_147438_o(checkLoc.x, checkLoc.y, checkLoc.z);
            IPowerInterface pi = PowerHandlerUtil.create(te);
            if (pi == null) continue;
            this.receptors.add(new Receptor(pi, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canRecieveFluid() || resource == null) {
            return null;
        }
        FluidStack in = resource.copy();
        FluidStack result = null;
        for (NetworkFluidHandler h : this.getNetworkHandlers()) {
            FluidStack res;
            if (!h.node.canSendFluid() || !h.handler.canDrain(h.dirOp, in.getFluid()) || (res = h.handler.drain(h.dirOp, in, false)) == null) continue;
            if (result == null) {
                result = res.copy();
                if (!doDrain) continue;
                h.handler.drain(h.dirOp, in, true);
                continue;
            }
            if (!result.isFluidEqual(res)) continue;
            result.amount += res.amount;
            if (doDrain) {
                h.handler.drain(h.dirOp, in, true);
            }
            in.amount -= res.amount;
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, int maxDrainIn, boolean doDrain) {
        if (!this.canRecieveFluid()) {
            return null;
        }
        int maxDrain = maxDrainIn;
        FluidStack result = null;
        for (NetworkFluidHandler h : this.getNetworkHandlers()) {
            FluidStack res;
            if (!h.node.canSendFluid() || (res = h.handler.drain(h.dirOp, maxDrain, false)) == null) continue;
            if (result == null) {
                result = res.copy();
                if (doDrain) {
                    h.handler.drain(h.dirOp, maxDrain, true);
                }
                maxDrain -= res.amount;
                continue;
            }
            if (!result.isFluidEqual(res)) continue;
            result.amount += res.amount;
            if (doDrain) {
                h.handler.drain(h.dirOp, maxDrain, true);
            }
            maxDrain -= res.amount;
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.canSendFluid()) {
            return false;
        }
        for (NetworkFluidHandler h : this.getNetworkHandlers()) {
            if (!h.node.canRecieveFluid() || !h.handler.canFill(h.dirOp, fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.canRecieveFluid()) {
            return false;
        }
        for (NetworkFluidHandler h : this.getNetworkHandlers()) {
            if (!h.node.canSendFluid() || !h.handler.canDrain(h.dirOp, fluid)) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        ArrayList<FluidTankInfo> res = new ArrayList<FluidTankInfo>();
        for (NetworkFluidHandler h : this.getNetworkHandlers()) {
            FluidTankInfo[] ti = h.handler.getTankInfo(h.dirOp);
            if (ti == null) continue;
            for (FluidTankInfo t : ti) {
                if (t == null) continue;
                res.add(t);
            }
        }
        if (res.isEmpty()) {
            return new FluidTankInfo[]{new FluidTankInfo(null, 0)};
        }
        return res.toArray(new FluidTankInfo[res.size()]);
    }

    private List<NetworkFluidHandler> getNetworkHandlers() {
        if (HyperCubeRegister.instance == null || !this.redstoneCheckPassed) {
            return Collections.emptyList();
        }
        List<TileHyperCube> cubes = HyperCubeRegister.instance.getCubesForChannel(this.channel);
        if (cubes == null || cubes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NetworkFluidHandler> result = new ArrayList<NetworkFluidHandler>();
        for (TileHyperCube cube : cubes) {
            List<NetworkFluidHandler> handlers;
            if (cube == this || cube == null || (handlers = cube.fluidHandlers) == null || handlers.isEmpty()) continue;
            result.addAll(handlers);
        }
        return result;
    }

    private void updateFluidHandlers() {
        if (!this.fluidHandlersDirty) {
            return;
        }
        this.fluidHandlers.clear();
        if (this.isConnected) {
            BlockCoord myLoc = new BlockCoord((TileEntity)this);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BlockCoord checkLoc = myLoc.getLocation(dir);
                TileEntity te = this.field_145850_b.func_147438_o(checkLoc.x, checkLoc.y, checkLoc.z);
                if (!(te instanceof IFluidHandler) || te instanceof TileHyperCube) continue;
                IFluidHandler fh = (IFluidHandler)te;
                this.fluidHandlers.add(new NetworkFluidHandler(this, fh, dir));
            }
            this.fluidHandlersDirty = false;
        }
    }

    public ItemRecieveBuffer getRecieveBuffer() {
        return this.recieveBuffer;
    }

    private void updateInventories() {
        this.recieveBuffer.setRecieveEnabled(this.canSendItems());
        if (!this.inventoriesDirty) {
            return;
        }
        this.localInventory = new CompositeInventory();
        BlockCoord myLoc = new BlockCoord((TileEntity)this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord checkLoc = myLoc.getLocation(dir);
            TileEntity te = this.field_145850_b.func_147438_o(checkLoc.x, checkLoc.y, checkLoc.z);
            if (!(te instanceof IInventory) || te instanceof TileHyperCube) continue;
            this.localInventory.addInventory((IInventory)te, dir);
        }
        this.inventoriesDirty = false;
    }

    void pushRecieveBuffer() {
        if (this.recieveBuffer.isEmpty()) {
            return;
        }
        List<TileHyperCube> cubes = HyperCubeRegister.instance.getCubesForChannel(this.channel);
        if (cubes == null || cubes.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.recieveBuffer.func_70302_i_(); ++i) {
            ItemStack toPush = this.recieveBuffer.func_70301_a(i);
            if (toPush == null) continue;
            for (TileHyperCube cube : cubes) {
                if (toPush == null || cube == this || cube == null || !cube.canRecieveItems()) continue;
                this.recieveBuffer.getItems()[i] = toPush = cube.recieveItems(toPush);
            }
        }
    }

    private ItemStack recieveItems(ItemStack toPush) {
        if (toPush == null) {
            return null;
        }
        ItemStack result = toPush.func_77946_l();
        BlockCoord myLoc = new BlockCoord((TileEntity)this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord checkLoc = myLoc.getLocation(dir);
            TileEntity te = this.field_145850_b.func_147438_o(checkLoc.x, checkLoc.y, checkLoc.z);
            result.field_77994_a -= ItemUtil.doInsertItem((Object)te, (ItemStack)result, (ForgeDirection)dir.getOpposite());
            if (result.field_77994_a > 0) continue;
            return null;
        }
        return result;
    }

    private ISidedInventory getRemoteInventory() {
        CompositeInventory res = new CompositeInventory();
        res.addInventory((IInventory)this.recieveBuffer, ForgeDirection.UNKNOWN);
        if (!this.canSendItems()) {
            return res;
        }
        if (HyperCubeRegister.instance == null) {
            return res;
        }
        List<TileHyperCube> cubes = HyperCubeRegister.instance.getCubesForChannel(this.channel);
        if (cubes == null || cubes.isEmpty()) {
            return res;
        }
        for (TileHyperCube cube : cubes) {
            if (cube == this || cube == null || !cube.canRecieveItems()) continue;
            if (cube.inventoriesDirty) {
                cube.updateInventories();
            }
            res.addInventory(cube.localInventory);
        }
        return res;
    }

    public int func_70302_i_() {
        return this.getRemoteInventory().func_70302_i_();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70301_a(int i) {
        return this.getRemoteInventory().func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.getRemoteInventory().func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.getRemoteInventory().func_70299_a(i, itemstack);
    }

    public int[] func_94128_d(int var1) {
        return this.getRemoteInventory().func_94128_d(var1);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.getRemoteInventory().func_102007_a(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return this.getRemoteInventory().func_102008_b(i, itemstack, j);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.getRemoteInventory().func_94041_b(i, itemstack);
    }

    public String func_145825_b() {
        return ModObject.blockHyperCube.unlocalisedName;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        int energy = nbtRoot.func_74764_b("storedEnergy") ? (int)(nbtRoot.func_74760_g("storedEnergy") * 10.0f) : nbtRoot.func_74762_e("storedEnergyRF");
        this.setEnergyStored(energy);
        String channelName = nbtRoot.func_74779_i("channelName");
        UUID channelUser = PlayerUtil.getPlayerUIDUnstable((String)nbtRoot.func_74779_i("channelUser"));
        this.channel = channelName != null && !channelName.isEmpty() ? new Channel(channelName, channelUser) : null;
        this.owner = PlayerUtil.getPlayerUIDUnstable((String)nbtRoot.func_74779_i("owner"));
        for (SubChannel subChannel : SubChannel.values()) {
            String key = "subChannel" + subChannel.ordinal();
            if (!nbtRoot.func_74764_b(key)) continue;
            this.setModeForChannel(subChannel, IoMode.values()[nbtRoot.func_74765_d(key)]);
        }
        this.recieveBuffer.readFromNBT(nbtRoot);
        this.redstoneControlMode = nbtRoot.func_74764_b("rsMode") ? RedstoneControlMode.values()[nbtRoot.func_74765_d("rsMode")] : RedstoneControlMode.IGNORE;
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("storedEnergyRF", this.storedEnergyRF);
        if (this.channel != null) {
            nbtRoot.func_74778_a("channelName", this.channel.name);
            if (this.channel.user != null) {
                nbtRoot.func_74778_a("channelUser", this.channel.user.toString());
            }
        }
        if (this.owner != null) {
            nbtRoot.func_74778_a("owner", this.owner.toString());
        }
        for (SubChannel subChannel : SubChannel.values()) {
            IoMode mode = this.getModeForChannel(subChannel);
            nbtRoot.func_74777_a("subChannel" + subChannel.ordinal(), (short)mode.ordinal());
        }
        if (this.redstoneControlMode != null) {
            nbtRoot.func_74777_a("rsMode", (short)this.redstoneControlMode.ordinal());
        }
        this.recieveBuffer.writeToNBT(nbtRoot);
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public static enum SubChannel {
        POWER,
        FLUID,
        ITEM;

    }

    public static enum IoMode {
        SEND("gui.send"),
        RECIEVE("gui.receive"),
        BOTH("gui.sendReceive"),
        NEITHER("gui.disabled");

        private final String unlocalisedName;

        public static IoMode next(IoMode mode) {
            int index = mode.ordinal() + 1;
            if (index >= IoMode.values().length) {
                index = 0;
            }
            return IoMode.values()[index];
        }

        public static boolean isRecieveEnabled(IoMode mode) {
            return mode == RECIEVE || mode == BOTH;
        }

        public static boolean isSendEnabled(IoMode mode) {
            return mode == SEND || mode == BOTH;
        }

        private IoMode(String unlocalisedName) {
            this.unlocalisedName = unlocalisedName;
        }

        public boolean isRecieveEnabled() {
            return IoMode.isRecieveEnabled(this);
        }

        public boolean isSendEnabled() {
            return IoMode.isSendEnabled(this);
        }

        public IoMode next() {
            return IoMode.next(this);
        }

        public String getUnlocalisedName() {
            return this.unlocalisedName;
        }

        public String getLocalisedName() {
            return EnderIO.lang.localize(this.unlocalisedName);
        }
    }

    static class Receptor {
        IPowerInterface receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerInterface rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }

    static class NetworkFluidHandler {
        final TileHyperCube node;
        final IFluidHandler handler;
        final ForgeDirection dir;
        final ForgeDirection dirOp;

        private NetworkFluidHandler(TileHyperCube node, IFluidHandler handler, ForgeDirection dir) {
            this.node = node;
            this.handler = handler;
            this.dir = dir;
            this.dirOp = dir.getOpposite();
        }
    }
}

