/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.ChatUtil;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.PacketConduitProbeMode;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.YetaWrenchPacketProcessor;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.SoundDetector;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TrackmanGogglesUpgrade;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.thaumcraft.GogglesOfRevealingUpgrade;
import crazypants.util.BaublesUtil;
import mods.railcraft.api.core.items.IToolGoggles;
import mods.railcraft.common.items.ItemGoggles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class KeyTracker {
    public static final KeyTracker instance = new KeyTracker();
    private final KeyBinding glideKey = new KeyBinding(EnderIO.lang.localize("keybind.glidertoggle"), 0, EnderIO.lang.localize("category.darksteelarmor"));
    private final KeyBinding soundDetectorKey;
    private final KeyBinding nightVisionKey;
    private final KeyBinding stepAssistKey;
    private final KeyBinding speedKey;
    private final KeyBinding jumpKey;
    private final KeyBinding gogglesKey;
    private final KeyBinding trackmansGogglesKey;
    private final KeyBinding yetaWrenchMode;
    private final KeyBinding magnetKey;
    private final KeyBinding staffOfTravelingTPKey;
    private static long lastBlinkTick = -1L;

    public KeyTracker() {
        ClientRegistry.registerKeyBinding((KeyBinding)this.glideKey);
        this.soundDetectorKey = new KeyBinding(EnderIO.lang.localize("keybind.soundlocator"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.soundDetectorKey);
        this.nightVisionKey = new KeyBinding(EnderIO.lang.localize("keybind.nightvision"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.nightVisionKey);
        this.gogglesKey = new KeyBinding(EnderIO.lang.localize("keybind.gogglesofrevealing"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.gogglesKey);
        this.trackmansGogglesKey = new KeyBinding(EnderIO.lang.localize("keybind.trackmansgoggles"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.trackmansGogglesKey);
        this.stepAssistKey = new KeyBinding(EnderIO.lang.localize("keybind.stepassist"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepAssistKey);
        this.speedKey = new KeyBinding(EnderIO.lang.localize("keybind.speed"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.speedKey);
        this.jumpKey = new KeyBinding(EnderIO.lang.localize("keybind.jump"), 0, EnderIO.lang.localize("category.darksteelarmor"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.jumpKey);
        this.yetaWrenchMode = new KeyBinding(EnderIO.lang.localize("keybind.yetawrenchmode"), 0, EnderIO.lang.localize("category.tools"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.yetaWrenchMode);
        this.magnetKey = new KeyBinding(EnderIO.lang.localize("keybind.magnet"), 0, EnderIO.lang.localize("category.tools"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.magnetKey);
        this.staffOfTravelingTPKey = new KeyBinding(EnderIO.lang.localize("keybind.staffoftravelingtp"), 0, EnderIO.lang.localize("category.tools"));
        ClientRegistry.registerKeyBinding((KeyBinding)this.staffOfTravelingTPKey);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.handleGlide();
        this.handleSoundDetector();
        this.handleNightVision();
        this.handleYetaWrench();
        this.handleGoggles();
        this.handleTrackmanGoggles();
        this.handleStepAssist();
        this.handleSpeed();
        this.handleJump();
        this.handleMagnet();
        this.handleStaffOfTravelingTP();
    }

    private void sendEnabledChatMessage(String messageBase, boolean isActive) {
        String message = messageBase.concat(isActive ? ".enabled" : ".disabled");
        ChatUtil.sendNoSpamClientUnloc((Lang)EnderIO.lang, (String[])new String[]{message});
    }

    private void toggleDarkSteelController(PacketUpgradeState.Type type, String messageBase) {
        boolean isActive = !DarkSteelController.instance.isActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type);
        this.sendEnabledChatMessage(messageBase, isActive);
        DarkSteelController.instance.setActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type, isActive);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(type, isActive));
    }

    private void handleStaffOfTravelingTP() {
        if (this.staffOfTravelingTPKey.func_151468_f()) {
            if (Config.travelStaffKeybindEnabled) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                if (player != null) {
                    ItemStack travelItem = player.func_70694_bm();
                    if (travelItem == null || travelItem.func_77973_b() == null || !(travelItem.func_77973_b() instanceof IItemOfTravel) || !((IItemOfTravel)travelItem.func_77973_b()).isActive((EntityPlayer)player, travelItem)) {
                        travelItem = TravelController.instance.findTravelItemInInventoryOrBaubles((EntityPlayer)player);
                    }
                    if (travelItem != null && travelItem.func_77973_b() != null) {
                        long ticksSinceBlink = EnderIO.proxy.getTickCount() - lastBlinkTick;
                        if (ticksSinceBlink < 0L) {
                            lastBlinkTick = -1L;
                        }
                        if (ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(travelItem, (EntityPlayer)player)) {
                            lastBlinkTick = EnderIO.proxy.getTickCount();
                        }
                    }
                }
            } else {
                TravelController.showMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (IChatComponent)new ChatComponentTranslation("enderio.travelStaffKeybind.isDisabled", new Object[0]));
            }
        }
    }

    private void handleMagnet() {
        if (this.magnetKey.func_151468_f()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack[] inv = player.field_71071_by.field_70462_a;
            for (int i = 0; i < 9; ++i) {
                if (inv[i] == null || inv[i].func_77973_b() == null || inv[i].func_77973_b() != DarkSteelItems.itemMagnet) continue;
                boolean isActive = !ItemMagnet.isActive(inv[i]);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.INVENTORY, i, isActive));
                return;
            }
            IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
            if (baubles != null) {
                for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                    ItemStack stack = baubles.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() == null || stack.func_77973_b() != DarkSteelItems.itemMagnet) continue;
                    boolean isActive = !ItemMagnet.isActive(stack);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.BAUBLES, i, isActive));
                    return;
                }
            }
        }
    }

    private void handleJump() {
        if (this.jumpKey.func_151468_f()) {
            if (!JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                return;
            }
            this.toggleDarkSteelController(PacketUpgradeState.Type.JUMP, "darksteel.upgrade.jump");
        }
    }

    private void handleSpeed() {
        if (this.speedKey.func_151468_f()) {
            if (!SpeedUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                return;
            }
            this.toggleDarkSteelController(PacketUpgradeState.Type.SPEED, "darksteel.upgrade.speed");
        }
    }

    private void handleStepAssist() {
        if (this.stepAssistKey.func_151468_f()) {
            if (!JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                return;
            }
            this.toggleDarkSteelController(PacketUpgradeState.Type.STEP_ASSIST, "darksteel.upgrade.stepAssist");
        }
    }

    private void handleTrackmanGoggles() {
        if (this.trackmansGogglesKey.func_151468_f()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (!TrackmanGogglesUpgrade.isUpgradeEquipped((EntityPlayer)player)) {
                return;
            }
            ItemStack helmet = player.func_71124_b(4);
            ((ItemDarkSteelArmor)helmet.func_77973_b()).incrementAura(helmet);
            IToolGoggles.displaySwitchMessage((World)Minecraft.func_71410_x().field_71441_e, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ItemGoggles.GoggleAura)((ItemDarkSteelArmor)helmet.func_77973_b()).getCurrentAura(helmet));
            return;
        }
    }

    private void handleGoggles() {
        if (this.gogglesKey.func_151468_f()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (!GogglesOfRevealingUpgrade.isUpgradeEquipped((EntityPlayer)player)) {
                return;
            }
            boolean isActive = !DarkSteelItems.itemDarkSteelHelmet.isGogglesUgradeActive();
            this.sendEnabledChatMessage("darksteel.upgrade.gogglesOfRevealing", isActive);
            DarkSteelItems.itemDarkSteelHelmet.setGogglesUgradeActive(isActive);
        }
    }

    private void handleYetaWrench() {
        if (!this.yetaWrenchMode.func_151468_f()) {
            if (this.yetaWrenchMode.func_151463_i() == 0) {
                Config.checkYetaAccess();
            }
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return;
        }
        if (equipped.func_77973_b() instanceof IConduitControl) {
            ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
            if (curMode == null) {
                curMode = ConduitDisplayMode.ALL;
            }
            ConduitDisplayMode newMode = player.func_70093_af() ? curMode.previous() : curMode.next();
            ConduitDisplayMode.setDisplayMode(equipped, newMode);
            PacketHandler.INSTANCE.sendToServer((IMessage)new YetaWrenchPacketProcessor(player.field_71071_by.field_70461_c, newMode));
        } else if (equipped.func_77973_b() == EnderIO.itemConduitProbe) {
            int newMeta = equipped.func_77960_j() == 0 ? 1 : 0;
            equipped.func_77964_b(newMeta);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbeMode());
            player.func_71038_i();
        }
    }

    private void handleSoundDetector() {
        if (!this.isSoundDetectorUpgradeEquipped(Minecraft.func_71410_x().field_71439_g)) {
            SoundDetector.instance.setEnabled(false);
            return;
        }
        if (this.soundDetectorKey.func_151468_f()) {
            boolean isActive = !SoundDetector.instance.isEnabled();
            this.sendEnabledChatMessage("darksteel.upgrade.sound", isActive);
            SoundDetector.instance.setEnabled(isActive);
        }
    }

    private void handleGlide() {
        if (this.glideKey.func_151468_f() && DarkSteelController.instance.isGliderUpgradeEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            this.toggleDarkSteelController(PacketUpgradeState.Type.GLIDE, "darksteel.upgrade.glider");
        }
    }

    private void handleNightVision() {
        if (this.nightVisionKey.func_151468_f()) {
            boolean isActive;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (!DarkSteelController.instance.isNightVisionUpgradeOrEnchEquipped((EntityPlayer)player)) {
                return;
            }
            boolean bl = isActive = !DarkSteelController.instance.isNightVisionActive();
            if (isActive) {
                player.field_70170_p.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, EnderIO.DOMAIN + ":ds.nightvision.on", 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f - 0.2f + 1.0f, false);
            } else {
                player.field_70170_p.func_72980_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, EnderIO.DOMAIN + ":ds.nightvision.off", 0.1f, 1.0f, false);
            }
            DarkSteelController.instance.setNightVisionActive(isActive);
        }
    }

    public boolean isSoundDetectorUpgradeEquipped(EntityClientPlayerMP player) {
        ItemStack helmet = player.func_71124_b(4);
        SoundDetectorUpgrade upgrade = SoundDetectorUpgrade.loadFromItem(helmet);
        return upgrade != null;
    }

    public KeyBinding getYetaWrenchMode() {
        return this.yetaWrenchMode;
    }
}

