/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.common.WirelessDataStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.dataTransport.ALRecipeDataPacket;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataConnector;
import tectech.util.CommonValues;

public class MTEHatchWirelessDataItemsOutput
extends MTEHatch {
    public ALRecipeDataPacket dataPacket = null;

    public MTEHatchWirelessDataItemsOutput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.wirelessdataoutass.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.wirelessdataoutass.desc.1")}, new ITexture[0]);
    }

    public MTEHatchWirelessDataItemsOutput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchWirelessDataItemsOutput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 0;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.dataPacket != null) {
            aNBT.func_74782_a("eDATA", (NBTBase)this.dataPacket.toNbt());
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("eDATA")) {
            this.dataPacket = new ALRecipeDataPacket(aNBT.func_74775_l("eDATA"));
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            aTick = MinecraftServer.func_71276_C().func_71259_af();
            if (this.dataPacket != null && aTick % 200L == 0L) {
                WirelessDataStore wirelessDataStore = WirelessDataStore.getWirelessDataSticks(this.getBaseMetaTileEntity().getOwnerUuid());
                wirelessDataStore.uploadData(Arrays.asList((GTRecipe.RecipeAssemblyLine[])this.dataPacket.getContent()), aTick);
            }
        }
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(MTEHatchDataConnector.EM_D_ACTIVE, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(MTEHatchDataConnector.EM_D_SIDES, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("recipeCount", this.dataPacket == null ? 0 : ((GTRecipe.RecipeAssemblyLine[])this.dataPacket.getContent()).length);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(this.translate("tt.keyphrase.AL_Recipe_Transmitting", tag.func_74762_e("recipeCount")));
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.dataPacket != null) {
            for (GTRecipe.RecipeAssemblyLine recipe : (GTRecipe.RecipeAssemblyLine[])this.dataPacket.getContent()) {
                lines.add(this.translate("tt.keyphrase.AL_Recipe_Desc", recipe.mOutput.func_82833_r()));
            }
        } else {
            lines.add(this.translate("tt.keyphrase.AL_Recipe_None"));
        }
        lines.sort(String::compareTo);
        lines.add(0, this.translate("tt.keyphrase.AL_Recipe_Header"));
        return lines.toArray(new String[0]);
    }
}

