/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.redstone;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.MTERedstoneBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTERedstoneButtonPanel
extends MTERedstoneBase {
    public byte mRedstoneStrength = 0;
    public byte mType = 0;
    public byte mUpdate = 0;
    public static TexturesGtBlock.CustomIcon[] sIconList = new TexturesGtBlock.CustomIcon[64];

    public MTERedstoneButtonPanel(int aID) {
        super(aID, "redstone.button.panel", "Button Panel", 5, 0, "Right-click with Screwdriver to change Button Design", new ITexture[0]);
    }

    public MTERedstoneButtonPanel(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 5, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERedstoneButtonPanel(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mRedstoneStrength", this.mRedstoneStrength);
        aNBT.func_74774_a("mType", this.mType);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mRedstoneStrength = aNBT.func_74771_c("mRedstoneStrength");
        this.mType = aNBT.func_74771_c("mType");
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mRedstoneStrength = (byte)(aValue & 0xF);
        this.mType = (byte)(aValue >>> 4);
    }

    @Override
    public byte getUpdateData() {
        return (byte)(this.mRedstoneStrength & 0xF | this.mType << 4);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.mUpdate = (byte)2;
                block0 : switch (this.mType) {
                    default: {
                        switch (side) {
                            case DOWN: 
                            case UP: {
                                this.mRedstoneStrength = (byte)((byte)(aX * 4.0f) + 4 * (byte)(aZ * 4.0f));
                                break;
                            }
                            case NORTH: {
                                this.mRedstoneStrength = (byte)((byte)(4.0f - aX * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                                break;
                            }
                            case SOUTH: {
                                this.mRedstoneStrength = (byte)((byte)(aX * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                                break;
                            }
                            case WEST: {
                                this.mRedstoneStrength = (byte)((byte)(aZ * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                                break;
                            }
                            case EAST: {
                                this.mRedstoneStrength = (byte)((byte)(4.0f - aZ * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (side) {
                            case DOWN: 
                            case UP: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aX * 2.0f) + 2 * (byte)(aZ * 2.0f));
                                break;
                            }
                            case NORTH: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(2.0f - aX * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                                break;
                            }
                            case SOUTH: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aX * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                                break;
                            }
                            case WEST: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aZ * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                                break;
                            }
                            case EAST: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(2.0f - aZ * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (side) {
                            case DOWN: 
                            case UP: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aZ * 4.0f));
                                break block0;
                            }
                            case NORTH: 
                            case SOUTH: 
                            case WEST: 
                            case EAST: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(4.0f - aY * 4.0f));
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
            if (this.mUpdate > 0) {
                this.mUpdate = (byte)(this.mUpdate - 1);
            } else if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                this.mRedstoneStrength = 0;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                this.getBaseMetaTileEntity().setStrongOutputRedstoneSignal(side, side == this.getBaseMetaTileEntity().getFrontFacing() ? (byte)0 : this.mRedstoneStrength);
                this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(side, side == this.getBaseMetaTileEntity().getFrontFacing() ? (byte)0 : this.mRedstoneStrength);
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mType = (byte)((this.mType + 1) % 3);
        }
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getSides(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getSidesActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(sIconList[this.mType * 16 + this.mRedstoneStrength])};
        }
        return this.mTextures[(aActive || this.hasRedstoneSignal() ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Redstone_Top_Main_Off)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Redstone_Top_Main_On)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Redstone_Bottom_Main_Off)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Redstone_Bottom_Main_On)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Redstone_Side_Main_Off)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Casing_Redstone_Side_Main_On)};
    }

    static {
        for (int i = 0; i < 64; ++i) {
            MTERedstoneButtonPanel.sIconList[i] = new TexturesGtBlock.CustomIcon("TileEntities/gt4/redstone/ButtonPanel/" + i);
        }
    }
}

