/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.materials;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.handler.Recipes.DecayableRecipe;
import gtPlusPlus.core.item.base.BaseItemTickable;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class DustDecayable
extends BaseItemTickable {
    private final ItemStack turnsIntoItem;
    private final int radLevel;

    public DustDecayable(String unlocal, int colour, int maxTicks, String[] desc1, ItemStack turnsInto, int radLevel, GTRecipeConstants.DecayType decayType) {
        super(true, true, unlocal, colour, maxTicks, desc1);
        this.turnsIntoItem = turnsInto;
        this.radLevel = radLevel;
        this.field_77777_bU = 64;
        GTOreDictUnificator.registerOre(unlocal, new ItemStack((Item)this));
        new DecayableRecipe(maxTicks, new ItemStack((Item)this), turnsInto, decayType);
    }

    @Override
    public void func_94581_a(IIconRegister reg) {
        String gt = Mods.GregTech.ID + ":materialicons/NUCLEAR/dust";
        this.mIcon[0] = reg.func_94245_a(gt);
        String gt2 = Mods.GregTech.ID + ":materialicons/NUCLEAR/dust_OVERLAY";
        this.mIcon[1] = reg.func_94245_a(gt2);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        if (this.radLevel > 0) {
            list.add(GTPPCore.GT_Tooltip_Radioactive.get());
        }
        list.add(GTUtility.translate("GTPP.tooltip.dust-decay-hint", ModBlocks.blockDecayablesChest.func_149732_F(), ItemList.DecayWarehouse.get(1L, new Object[0]).func_82833_r()));
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entityHolding, int slot, boolean heldInHand) {
        if (world == null || stack == null || world.field_72995_K) {
            return;
        }
        if (entityHolding instanceof EntityPlayer) {
            EntityUtils.applyRadiationDamageToEntity(stack.field_77994_a, this.radLevel, world, entityHolding);
        }
    }

    public ItemStack getDecayResult() {
        return this.turnsIntoItem;
    }
}

