/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GTUtility;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class ResultInsufficientVoltage
implements CheckRecipeResult {
    private long required;

    ResultInsufficientVoltage(long required) {
        this.required = required;
    }

    @Override
    @Nonnull
    @NotNull
    public String getID() {
        return "insufficient_voltage";
    }

    @Override
    public boolean wasSuccessful() {
        return false;
    }

    @Override
    @Nonnull
    @NotNull
    public String getDisplayString() {
        return Objects.requireNonNull(StatCollector.func_74837_a((String)"GT5U.gui.text.insufficient_voltage", (Object[])new Object[]{GTUtility.formatNumbers(this.required), GTUtility.getColoredTierNameFromVoltage(this.required)}));
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        tag.func_74772_a("required", this.required);
        return tag;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        this.required = tag.func_74763_f("required");
    }

    @Override
    @Nonnull
    @NotNull
    public CheckRecipeResult newInstance() {
        return new ResultInsufficientVoltage(0L);
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.writeLong(this.required);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buffer) {
        this.required = buffer.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultInsufficientVoltage that = (ResultInsufficientVoltage)o;
        return this.required == that.required;
    }
}

