/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import mantle.common.network.AbstractPacket;
import modwarriors.notenoughkeys.api.Api;
import modwarriors.notenoughkeys.api.KeyBindingPressedEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.TConstruct;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.PlayerAbilityHelper;
import tconstruct.armor.items.TravelGear;
import tconstruct.util.network.AccessoryInventoryPacket;
import tconstruct.util.network.BeltPacket;
import tconstruct.util.network.DoubleJumpPacket;
import tconstruct.util.network.GogglePacket;

public class ArmorControls {
    public static final String keybindCategory = "tconstruct.keybindings";
    public static final String[] keyDescs = new String[]{"key.tarmor", "key.tgoggles", "key.tbelt", "key.tzoom"};
    public static KeyBinding armorKey = new KeyBinding(keyDescs[0], 0, "tconstruct.keybindings");
    public static KeyBinding toggleGoggles = new KeyBinding(keyDescs[1], 0, "tconstruct.keybindings");
    public static KeyBinding beltSwap = new KeyBinding(keyDescs[2], 0, "tconstruct.keybindings");
    public static KeyBinding zoomKey = new KeyBinding(keyDescs[3], 0, "tconstruct.keybindings");
    static KeyBinding jumpKey;
    static KeyBinding invKey;
    static Minecraft mc;
    boolean jumping;
    int midairJumps = 0;
    boolean climbing = false;
    boolean onGround = false;
    public static boolean zoom;
    boolean activeGoggles = false;
    int currentTab = 1;
    private final KeyBinding[] keys;
    private boolean isNotEnoughKeysLoaded;

    public ArmorControls() {
        ArmorControls.getVanillaKeyBindings();
        this.keys = new KeyBinding[]{armorKey, toggleGoggles, beltSwap, zoomKey, null, null};
        EventHandler handler = new EventHandler();
        FMLCommonHandler.instance().bus().register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
    }

    public void registerKeys() {
        for (KeyBinding key : this.keys) {
            if (key == null) continue;
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
        this.isNotEnoughKeysLoaded = Loader.isModLoaded((String)"notenoughkeys");
        if (this.isNotEnoughKeysLoaded) {
            Api.registerMod((String)"TConstruct", (String[])keyDescs);
        }
        this.keys[4] = jumpKey;
        this.keys[5] = invKey;
    }

    private static void getVanillaKeyBindings() {
        mc = Minecraft.func_71410_x();
        jumpKey = ArmorControls.mc.field_71474_y.field_74314_A;
        invKey = ArmorControls.mc.field_71474_y.field_151445_Q;
    }

    public void keyEvent(InputEvent.KeyInputEvent event) {
        if (!this.isNotEnoughKeysLoaded) {
            this.checkAndPerformKeyActions(null, false);
        }
    }

    public void mouseEvent(InputEvent.MouseInputEvent event) {
        this.checkAndPerformKeyActions(null, false);
    }

    @Optional.Method(modid="notenoughkeys")
    public void keyEventSpecial(KeyBindingPressedEvent event) {
        if (event.keyBinding != null && event.isKeyBindingPressed) {
            this.checkAndPerformKeyActions(event.keyBinding, true);
        }
    }

    private void checkAndPerformKeyActions(KeyBinding keyBinding, boolean inputFromNotEnoughKeys) {
        if (inputFromNotEnoughKeys ? keyBinding == armorKey : armorKey.func_151468_f()) {
            ArmorControls.openArmorGui();
            return;
        }
        if (inputFromNotEnoughKeys ? keyBinding == jumpKey : jumpKey.func_151468_f()) {
            this.performHigherJump();
            return;
        }
        if (ArmorControls.mc.field_71462_r == null) {
            if (inputFromNotEnoughKeys ? keyBinding == toggleGoggles : toggleGoggles.func_151468_f()) {
                this.checkAndToggleNightVision();
                return;
            }
            if (inputFromNotEnoughKeys ? keyBinding == beltSwap : beltSwap.func_151468_f()) {
                ArmorControls.doBeltSwapIfPossible();
                return;
            }
            if (inputFromNotEnoughKeys ? keyBinding == zoomKey : zoomKey.func_151468_f()) {
                zoom = !zoom;
            }
        }
    }

    private void performHigherJump() {
        if (ArmorControls.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.jumping && this.midairJumps > 0) {
            ArmorControls.mc.field_71439_g.field_70181_x = 0.42;
            ArmorControls.mc.field_71439_g.field_70143_R = 0.0f;
            if (ArmorControls.mc.field_71439_g.func_70644_a(Potion.field_76430_j)) {
                ArmorControls.mc.field_71439_g.field_70181_x += (double)((float)(ArmorControls.mc.field_71439_g.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
            }
            --this.midairJumps;
            this.resetFallDamage();
        }
        if (!this.jumping) {
            ItemStack wings;
            this.jumping = ArmorControls.mc.field_71439_g.field_70160_al;
            ItemStack shoes = ArmorControls.mc.field_71439_g.func_82169_q(0);
            if (shoes != null && shoes.func_77942_o() && shoes.func_77978_p().func_74764_b("TinkerArmor")) {
                NBTTagCompound shoeTag = shoes.func_77978_p().func_74775_l("TinkerArmor");
                this.midairJumps += shoeTag.func_74762_e("Double-Jump");
            }
            if ((wings = ArmorControls.mc.field_71439_g.func_82169_q(1)) != null && wings.func_77942_o() && wings.func_77978_p().func_74764_b("TinkerArmor")) {
                NBTTagCompound shoeTag = wings.func_77978_p().func_74775_l("TinkerArmor");
                this.midairJumps += shoeTag.func_74762_e("Double-Jump");
            }
        }
    }

    private void checkAndToggleNightVision() {
        ItemStack goggles = ArmorControls.mc.field_71439_g.func_82169_q(3);
        if (goggles != null && goggles.func_77973_b() instanceof TravelGear && goggles.func_77942_o() && goggles.func_77978_p().func_74775_l(((TravelGear)goggles.func_77973_b()).getBaseTagName()).func_74767_n("Night Vision")) {
            this.activeGoggles = !this.activeGoggles;
            PlayerAbilityHelper.toggleGoggles((EntityPlayer)ArmorControls.mc.field_71439_g, this.activeGoggles);
            this.toggleGoggles();
        }
    }

    public static boolean doBeltSwapIfPossible() {
        if (ArmorProxyClient.armorExtended.inventory[3] != null) {
            PlayerAbilityHelper.swapBelt((EntityPlayer)ArmorControls.mc.field_71439_g, ArmorProxyClient.armorExtended);
            ArmorControls.toggleBelt();
            return true;
        }
        return false;
    }

    public void landOnGround() {
        this.midairJumps = 0;
        this.jumping = false;
    }

    public void resetControls() {
        this.midairJumps = 0;
        this.jumping = false;
        this.climbing = false;
        this.onGround = false;
    }

    void resetFallDamage() {
        DoubleJumpPacket packet = new DoubleJumpPacket();
        ArmorControls.updateServer(packet);
    }

    public static void openArmorGui() {
        AccessoryInventoryPacket packet = new AccessoryInventoryPacket(101);
        ArmorControls.updateServer(packet);
    }

    public static void openKnapsackGui() {
        AccessoryInventoryPacket packet = new AccessoryInventoryPacket(102);
        ArmorControls.updateServer(packet);
    }

    private void toggleGoggles() {
        GogglePacket packet = new GogglePacket(this.activeGoggles);
        ArmorControls.updateServer(packet);
    }

    private static void toggleBelt() {
        BeltPacket packet = new BeltPacket();
        ArmorControls.updateServer(packet);
    }

    static void updateServer(AbstractPacket abstractPacket) {
        TConstruct.packetPipeline.sendToServer(abstractPacket);
    }

    static {
        zoom = false;
    }

    public class EventHandler {
        @SubscribeEvent
        public void keyEventWrapper(InputEvent.KeyInputEvent event) {
            ArmorControls.this.keyEvent(event);
        }

        @SubscribeEvent
        public void mouseEventWrapper(InputEvent.MouseInputEvent event) {
            ArmorControls.this.mouseEvent(event);
        }

        @Optional.Method(modid="notenoughkeys")
        @SubscribeEvent
        public void keyEventSpecialWrapper(KeyBindingPressedEvent event) {
            ArmorControls.this.keyEventSpecial(event);
        }
    }
}

