/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.items.contents.CellUpgrades;
import appeng.parts.automation.UpgradeInventory;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.container.ContainerWithNetworkTool;
import thaumicenergistics.common.container.slot.SlotRestrictive;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.common.tiles.TileEssentiaCellWorkbench;
import thaumicenergistics.common.utils.EffectiveSide;

public class ContainerEssentiaCellWorkbench
extends ContainerWithNetworkTool {
    private static int PLAYER_INV_POSITION_Y = 169;
    private static int HOTBAR_INV_POSITION_Y = PLAYER_INV_POSITION_Y + 58;
    public static int CELL_SLOT_X = 152;
    public static int CELL_SLOT_Y = 8;
    public final TileEssentiaCellWorkbench workbench;
    private final Slot cellSlot;

    public ContainerEssentiaCellWorkbench(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        this.workbench = (TileEssentiaCellWorkbench)world.func_147438_o(x, y, z);
        this.cellSlot = new SlotRestrictive(this.workbench, 0, CELL_SLOT_X, CELL_SLOT_Y);
        this.func_75146_a(this.cellSlot);
        this.bindPlayerInventory((IInventory)this.player.field_71071_by, PLAYER_INV_POSITION_Y, HOTBAR_INV_POSITION_Y);
        if (EffectiveSide.isServerSide()) {
            this.workbench.registerListener(this);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.workbench != null) {
            return this.workbench.func_70300_a(player);
        }
        return false;
    }

    public void createUpgradeSlots(ItemStack stack) {
        if (stack != null) {
            if (this.haveUpgradeSlots()) {
                this.removeUpgradeSlots();
            }
            this.addUpgradeSlots((UpgradeInventory)new CellUpgrades(stack, 5), 5, 187, 8);
        } else if (this.haveUpgradeSlots()) {
            this.removeUpgradeSlots();
        }
        if (EffectiveSide.isServerSide()) {
            Packet_C_AspectSlot.setUpgradeSlots(stack, this.player);
        }
    }

    public void onClientRequestPartitionList() {
        this.onPartitionChanged(this.workbench.getPartitionList());
    }

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        if (EffectiveSide.isServerSide()) {
            this.workbench.removeListener(this);
        }
    }

    public void onPartitionChanged(ArrayList<Aspect> partitionList) {
        this.createUpgradeSlots(this.workbench.func_70301_a(0));
        Packet_C_AspectSlot.setFilterList(partitionList, this.player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (EffectiveSide.isClientSide()) {
            return null;
        }
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (slot == this.cellSlot) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            } else if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (!this.cellSlot.func_75216_d() && this.cellSlot.func_75214_a(slotStack)) {
                    this.cellSlot.func_75215_d(slotStack.func_77946_l());
                    slotStack.field_77994_a = 0;
                    didMerge = true;
                }
                if (!didMerge) {
                    Aspect slotAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(slotStack);
                    if (slotAspect != null) {
                        didMerge = this.workbench.addAspectToPartition(slotAspect);
                    }
                    if (!didMerge) {
                        didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                    }
                }
            }
            if (didMerge) {
                if (slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
            }
        }
        return null;
    }
}

