/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import bartworks.common.loaders.FluidLoader;
import com.gtnewhorizon.gtnhlib.util.data.IMod;
import com.gtnewhorizon.gtnhlib.util.data.LazyBlock;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.utils.LazyBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.init.Blocks;
import tectech.thing.casing.TTCasingsContainer;

public class InteropConstants {
    public static final LazyBlock BRIGHT_AIR = new LazyBlock((IMod)Mods.GalacticraftCore, "tile.brightAir", Short.MAX_VALUE);
    public static final LazyBlock ARCANE_LAMP_LIGHT = new LazyBlock((IMod)Mods.Thaumcraft, "blockAiry", 2);
    public static final LazyBlock WIRELESS_CONNECTOR = new LazyBlock((IMod)Mods.AE2Stuff, "Wireless");
    public static final LazyBlockSpec AE_BLOCK_CABLE = LazyBlockSpec.ofBlock(Mods.AppliedEnergistics2, "tile.BlockCableBus", 0);
    public static final LazyBlock FMP_BLOCK = new LazyBlock((IMod)Mods.ForgeMultipart, "block");
    public static final LazyBlockSpec ENDER_STORAGE = LazyBlockSpec.ofBlock(Mods.EnderStorage, "enderChest", Short.MAX_VALUE);

    private InteropConstants() {
    }

    public static boolean isAir(Block block, int meta) {
        return block.func_149688_o() instanceof MaterialTransparent;
    }

    public static boolean skipWhenCopying(Block block, int meta) {
        if (block.func_149688_o() instanceof MaterialLiquid) {
            return true;
        }
        if (Mods.GregTech.isModLoaded() && InteropConstants.isGTRenderer(block)) {
            return true;
        }
        if (FMP_BLOCK.matches(block, meta)) {
            return true;
        }
        if (BRIGHT_AIR.matches(block, meta)) {
            return true;
        }
        return ARCANE_LAMP_LIGHT.matches(block, meta);
    }

    public static boolean shouldDropItem(Block block, int meta) {
        if (Mods.GregTech.isModLoaded() && InteropConstants.isGTRenderer(block)) {
            return false;
        }
        if (BRIGHT_AIR.matches(block, meta)) {
            return false;
        }
        return !ARCANE_LAMP_LIGHT.matches(block, meta);
    }

    @Optional(value={"gregtech_nh"})
    private static boolean isGTRenderer(Block block) {
        if (block == GregTechAPI.sDroneRender) {
            return true;
        }
        if (block == GregTechAPI.sWormholeRender) {
            return true;
        }
        if (block == GregTechAPI.sBlackholeRender) {
            return true;
        }
        if (block == TTCasingsContainer.eyeOfHarmonyRenderBlock) {
            return true;
        }
        if (block == TTCasingsContainer.forgeOfGodsRenderBlock) {
            return true;
        }
        if (block == FluidLoader.bioFluidBlock) {
            return true;
        }
        return block == Loaders.antimatterRenderBlock;
    }

    public static boolean isFree(Block block, int metadata) {
        if (block == Blocks.field_150350_a) {
            return true;
        }
        if (FMP_BLOCK.matches(block, metadata)) {
            return true;
        }
        return AE_BLOCK_CABLE.matches(block, metadata);
    }
}

