/*
 * Decompiled with CFR 0.152.
 */
package thaumic.tinkerer.common.block.tile.tablet;

import appeng.api.movable.IMovableTile;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import gregtech.common.tileentities.machines.basic.MTEWorldAccelerator;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import thaumic.tinkerer.common.ThaumicTinkerer;
import thaumic.tinkerer.common.block.tile.tablet.TabletFakePlayer;
import thaumic.tinkerer.common.registry.TTRegistry;
import thaumic.tinkerer.mixins.early.AccessorItemInWorldManager;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="appeng.api.movable.IMovableTile", modid="appliedenergistics2")})
public class TileAnimationTablet
extends TileEntity
implements IInventory,
IMovableTile,
IPeripheral,
SimpleComponent {
    private static final String TAG_LEFT_CLICK = "leftClick";
    private static final String TAG_REDSTONE = "redstone";
    private static final String TAG_PROGRESS = "progress";
    private static final String TAG_MOD = "mod";
    private static final int[][] LOC_INCREASES = new int[][]{{0, -1}, {0, 1}, {-1, 0}, {1, 0}};
    private static final byte SWING_SPEED = 3;
    private static final byte MAX_DEGREE = 45;
    private static final byte MAX_ITERATIONS = 15;
    public boolean leftClick = true;
    public boolean redstone = false;
    private byte prevSwingProgress;
    private byte swingProgress;
    private byte swingMod;
    public ItemStack heldItem;
    private TabletFakePlayer player;
    private boolean isBreaking = false;
    private int ticksElapsed;
    private int prevTicksElapsed;
    private final Vec3 tempVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private final Vec3 positionVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    @SideOnly(value=Side.CLIENT)
    public final float getRenderSwingProgress(float partialTicks) {
        return (float)this.prevSwingProgress + (float)(this.swingProgress - this.prevSwingProgress) * partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public final float getTicksExisted(float partialTicks) {
        return (float)this.prevTicksElapsed + (float)(this.ticksElapsed - this.prevTicksElapsed) * partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public final int getWorldAcceleratorBonus() {
        return this.ticksElapsed - this.prevTicksElapsed - 1;
    }

    public void func_145845_h() {
        block18: {
            if (this.field_145850_b.field_72995_K) {
                this.prevSwingProgress = this.swingProgress;
                this.prevTicksElapsed = this.ticksElapsed;
                int iterations = ThaumicTinkerer.gtLoaded ? MTEWorldAccelerator.getAccelerationForTEUnsafe((TileEntity)this) + 1 : 1;
                this.ticksElapsed += iterations;
                ItemStack stack = this.heldItem;
                if (stack != null) {
                    iterations = Math.min(iterations, 15);
                    for (int i = 0; i < iterations; ++i) {
                        this.swingProgress = (byte)(this.swingProgress + this.swingMod);
                        if (this.swingProgress >= 45) {
                            this.swingMod = (byte)-3;
                            continue;
                        }
                        if (this.swingProgress > 0) continue;
                        this.stopSwinging();
                    }
                } else {
                    this.stopSwinging();
                }
                return;
            }
            try {
                this.player.func_70071_h_();
                ItemStack stack = this.heldItem;
                if (stack == null) {
                    if (this.isBreaking) {
                        this.stopBreaking();
                    }
                    this.stopSwinging();
                    return;
                }
                MovingObjectPosition hit = this.calculateHit();
                this.swingProgress = (byte)(this.swingProgress + this.swingMod);
                if (this.swingProgress >= 45) {
                    if (hit != null) {
                        this.swingHit(stack, hit);
                    }
                    this.swingMod = (byte)-3;
                } else if (this.swingProgress <= 0) {
                    this.stopSwinging();
                }
                if (this.isBreaking) {
                    if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                        this.stopBreaking();
                        return;
                    }
                    ItemInWorldManager worldManager = this.player.field_71134_c;
                    worldManager.func_73075_a();
                    if (((AccessorItemInWorldManager)worldManager).getDurabilityRemainingOnBlock() >= 10) {
                        worldManager.func_73084_b(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    }
                }
                if (!this.isIdle() || hit == null || this.redstone && !this.isBreaking) break block18;
                if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.MISS && (this.leftClick || !this.canPlaceItem(stack))) {
                    return;
                }
                this.initiateSwing();
            }
            catch (Throwable e) {
                e.printStackTrace();
                List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 8), (double)(this.field_145848_d - 8), (double)(this.field_145849_e - 8), (double)(this.field_145851_c + 8), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + 8)));
                for (EntityPlayer player : list) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Something went wrong with a Tool Dynamism Tablet! Check your FML log."));
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED.toString() + EnumChatFormatting.ITALIC + e.getMessage()));
                }
            }
        }
    }

    private boolean canPlaceItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemBlock || item instanceof ItemReed;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            if (this.player == null) {
                this.player = new TabletFakePlayer(this);
            }
            this.player.field_70170_p = this.field_145850_b;
        }
    }

    private void swingHit(ItemStack stack, MovingObjectPosition hit) {
        if (this.leftClick) {
            int z;
            int y;
            int x;
            Block block;
            if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                this.player.func_71059_n(hit.field_72308_g);
                this.updateState();
            } else if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !this.isBreaking && !(block = this.field_145850_b.func_147439_a(x = hit.field_72311_b, y = hit.field_72312_c, z = hit.field_72309_d)).isAir((IBlockAccess)this.field_145850_b, x, y, z) && block.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f) {
                this.isBreaking = true;
                this.player.field_71134_c.func_73074_a(x, y, z, hit.field_72310_e);
                this.updateState();
            }
        } else {
            boolean result;
            if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                if (this.player.func_70998_m(hit.field_72308_g)) {
                    this.updateState();
                }
                return;
            }
            int x = hit.field_72311_b;
            int y = hit.field_72312_c;
            int z = hit.field_72309_d;
            int side = hit.field_72310_e;
            boolean bl = result = !ForgeEventFactory.onPlayerInteract((EntityPlayer)this.player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)this.field_145850_b).isCanceled();
            if (result) {
                Vec3 hitVec = hit.field_72307_f;
                if (this.player.onPlayerRightClick(stack, x, y, z, side, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c)) {
                    this.updateState();
                    return;
                }
            }
            if (this.player.sendUseItem(stack)) {
                this.updateState();
            }
        }
    }

    public final boolean isIdle() {
        return this.swingMod == 0;
    }

    public final boolean getIsBreaking() {
        return this.isBreaking;
    }

    private void stopSwinging() {
        this.swingProgress = 0;
        this.swingMod = 0;
    }

    private void stopBreaking() {
        this.player.field_71134_c.func_73075_a();
        this.isBreaking = false;
        int[] increase = LOC_INCREASES[(this.func_145832_p() & 7) - 2];
        int x = this.field_145851_c + increase[0];
        int y = this.field_145848_d;
        int z = this.field_145849_e + increase[1];
        this.field_145850_b.func_147443_d(this.player.func_145782_y(), x, y, z, -1);
    }

    private void updateState() {
        ItemStack stack = this.player.func_70694_bm();
        if (stack == null || stack.field_77994_a <= 0) {
            this.heldItem = null;
            this.player.syncSlots();
        } else {
            this.heldItem = stack;
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private MovingObjectPosition calculateHit() {
        List entities;
        int meta = this.func_145832_p();
        if (meta == 0) {
            ThaumicTinkerer.log.error("Metadata of a Tool Dynamism tablet is in an invalid state. This is a critical error.");
            return null;
        }
        int[] increase = LOC_INCREASES[(meta & 7) - 2];
        int x = this.field_145851_c + increase[0];
        int y = this.field_145848_d;
        int z = this.field_145849_e + increase[1];
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        MovingObjectPosition hit = null;
        Vec3 position = this.positionVec;
        position.field_72450_a = (float)this.field_145851_c + 0.5f;
        position.field_72448_b = (float)this.field_145848_d + 0.5f;
        position.field_72449_c = (float)this.field_145849_e + 0.5f;
        if (!this.field_145850_b.func_147437_c(x, y, z)) {
            block.func_149719_a((IBlockAccess)this.field_145850_b, x, y, z);
            AxisAlignedBB aabb = block.func_149668_a(this.field_145850_b, x, y, z);
            if (aabb != null) {
                hit = block.func_149731_a(this.field_145850_b, x, y, z, position, this.getMiddleOfAABB(aabb));
            }
        }
        if (!(entities = this.field_145850_b.func_72839_b((Entity)this.player, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)))).isEmpty()) {
            double dist = hit == null ? Double.MAX_VALUE : position.func_72436_e(hit.field_72307_f);
            Entity targetedEntity = null;
            Vec3 hitVec = null;
            for (Entity e : entities) {
                double entityDist;
                if (!e.func_70067_L()) continue;
                float borderSize = e.func_70111_Y();
                AxisAlignedBB aabb = e.field_70121_D.func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
                MovingObjectPosition intercept = aabb.func_72327_a(position, this.getMiddleOfAABB(aabb));
                if (aabb.func_72318_a(position)) {
                    targetedEntity = e;
                    hitVec = intercept == null ? position : intercept.field_72307_f;
                    break;
                }
                if (intercept == null || !(dist > (entityDist = position.func_72436_e(intercept.field_72307_f)))) continue;
                hitVec = intercept.field_72307_f;
                targetedEntity = e;
                dist = entityDist;
            }
            if (targetedEntity != null) {
                hit = new MovingObjectPosition(targetedEntity, hitVec);
            }
        }
        if (hit == null && !this.field_145850_b.func_147437_c(x, --y, z)) {
            block = this.field_145850_b.func_147439_a(x, y, z);
            block.func_149719_a((IBlockAccess)this.field_145850_b, x, y, z);
            AxisAlignedBB aabb = block.func_149668_a(this.field_145850_b, x, y, z);
            if (aabb != null) {
                Vec3 vec = this.getMiddleOfAABB(aabb);
                vec.field_72448_b = aabb.field_72337_e - (double)y;
                hit = new MovingObjectPosition(x, y, z, ForgeDirection.UP.ordinal(), vec, false);
            }
        }
        return hit;
    }

    private Vec3 getMiddleOfAABB(AxisAlignedBB aabb) {
        this.tempVec.field_72450_a = (aabb.field_72340_a + aabb.field_72336_d) / 2.0;
        this.tempVec.field_72448_b = (aabb.field_72338_b + aabb.field_72337_e) / 2.0;
        this.tempVec.field_72449_c = (aabb.field_72339_c + aabb.field_72334_f) / 2.0;
        return this.tempVec;
    }

    public void initiateSwing() {
        this.swingMod = (byte)3;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, TTRegistry.dynamismTablet, 0, 0);
    }

    public boolean func_145842_c(int id, int type) {
        if (!this.field_145850_b.field_72995_K) {
            return true;
        }
        if (id == 0) {
            this.swingMod = (byte)3;
            this.swingProgress = 0;
            return true;
        }
        return this.field_145846_f;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.swingProgress = tag.func_74771_c(TAG_PROGRESS);
        this.swingMod = tag.func_74771_c(TAG_MOD);
        this.readCustomNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a(TAG_PROGRESS, this.swingProgress);
        tag.func_74774_a(TAG_MOD, this.swingMod);
        this.writeCustomNBT(tag);
    }

    private void readCustomNBT(NBTTagCompound tag) {
        this.leftClick = tag.func_74767_n(TAG_LEFT_CLICK);
        this.redstone = tag.func_74767_n(TAG_REDSTONE);
        if (tag.func_74764_b("Item")) {
            NBTTagCompound itemTag = tag.func_74775_l("Item");
            this.heldItem = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            return;
        }
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        if (tagList.func_74745_c() != 0) {
            this.heldItem = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(0));
        }
    }

    public S35PacketUpdateTileEntity getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, tag);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        this.readCustomNBT(packet.func_148857_g());
    }

    private void writeCustomNBT(NBTTagCompound tag) {
        tag.func_74757_a(TAG_LEFT_CLICK, this.leftClick);
        tag.func_74757_a(TAG_REDSTONE, this.redstone);
        tag.func_74782_a("Item", (NBTBase)(this.heldItem == null ? new NBTTagCompound() : this.heldItem.func_77955_b(new NBTTagCompound())));
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return i == 0 ? this.heldItem : null;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 0 && this.heldItem != null) {
            ItemStack stackAt;
            if (this.heldItem.field_77994_a <= count) {
                stackAt = this.heldItem;
                this.heldItem = null;
            } else {
                stackAt = this.heldItem.func_77979_a(count);
                if (this.heldItem.field_77994_a == 0) {
                    this.heldItem = null;
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return stackAt;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i != 0) {
            return;
        }
        this.heldItem = itemstack;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public String func_145825_b() {
        return "animationTablet";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public String getType() {
        return "tt_animationTablet";
    }

    public String[] getMethodNames() {
        return new String[]{"getRedstone", "setRedstone", "getLeftClick", "setLeftClick", "getRotation", "setRotation", "hasItem", "trigger"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.redstone;
                break;
            }
            case 1: {
                objectArray = this.setRedstoneImplementation((Boolean)arguments[0]);
                break;
            }
            case 2: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.leftClick;
                break;
            }
            case 3: {
                objectArray = this.setLeftClickImplementation((Boolean)arguments[0]);
                break;
            }
            case 4: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.func_145832_p() - 2;
                break;
            }
            case 5: {
                objectArray = this.setRotationImplementation((Double)arguments[0]);
                break;
            }
            case 6: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.heldItem != null;
                break;
            }
            case 7: {
                objectArray = this.triggerImplementation();
                break;
            }
            default: {
                objectArray = null;
            }
        }
        return objectArray;
    }

    private Object[] triggerImplementation() {
        if (!this.isIdle()) {
            return new Object[]{false};
        }
        this.initiateSwing();
        return new Object[]{true};
    }

    @Optional.Method(modid="ComputerCraft")
    private Object[] setRotationImplementation(Double argument) throws LuaException {
        int rotation = (int)argument.doubleValue();
        if (rotation > 3) {
            throw new LuaException("Invalid value: " + rotation + ".");
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, rotation + 2, 3);
        return null;
    }

    private Object[] setLeftClickImplementation(Boolean argument) {
        this.leftClick = argument;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    private Object[] setRedstoneImplementation(Boolean argument) {
        this.redstone = argument;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return ((Object)((Object)this)).equals(other);
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean prepareToMove() {
        this.stopBreaking();
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void doneMoving() {
    }

    public String getComponentName() {
        return this.getType();
    }

    @Callback(doc="function():boolean -- Returns Whether tablet is redstone activated")
    @Optional.Method(modid="OpenComputers")
    public Object[] getRedstone(Context context, Arguments args) {
        return new Object[]{this.redstone};
    }

    @Callback(doc="function(boolean):Nil -- Sets Whether tablet is redstone activated")
    @Optional.Method(modid="OpenComputers")
    public Object[] setRedstone(Context context, Arguments args) {
        this.setRedstoneImplementation(args.checkBoolean(0));
        return new Object[]{this.redstone};
    }

    @Callback(doc="function():boolean -- Returns Whether tablet Left clicks")
    @Optional.Method(modid="OpenComputers")
    public Object[] getLeftClick(Context context, Arguments args) {
        return new Object[]{this.leftClick};
    }

    @Callback(doc="function(boolean):Nil -- Sets Whether tablet Left Clicks")
    @Optional.Method(modid="OpenComputers")
    public Object[] setLeftClick(Context context, Arguments args) {
        this.setLeftClickImplementation(args.checkBoolean(0));
        return new Object[]{this.leftClick};
    }

    @Callback(doc="function():number -- Returns tablet Rotation")
    @Optional.Method(modid="OpenComputers")
    public Object[] getRotation(Context context, Arguments args) {
        return new Object[]{this.func_145832_p() - 2};
    }

    @Callback(doc="function(number):Nil -- Sets tablet rotation")
    @Optional.Method(modid="OpenComputers")
    public Object[] setRotation(Context context, Arguments args) throws LuaException {
        this.setRotationImplementation(Double.valueOf(args.checkInteger(0)));
        return new Object[]{this.func_145832_p() - 2};
    }

    @Callback(doc="function():boolean -- Returns wether tablet has an item or not")
    @Optional.Method(modid="OpenComputers")
    public Object[] hasItem(Context context, Arguments args) {
        return new Object[]{this.heldItem != null};
    }

    @Callback(doc="function():Nil -- Triggers tablets swing")
    @Optional.Method(modid="OpenComputers")
    public Object[] trigger(Context context, Arguments args) {
        return this.triggerImplementation();
    }
}

