/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.IDyable;
import mods.battlegear2.api.RenderItemBarEvent;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.weapons.IBackStabbable;
import mods.battlegear2.api.weapons.IExtendedReachWeapon;
import mods.battlegear2.api.weapons.IHitTimeModifier;
import mods.battlegear2.api.weapons.IPenetrateWeapon;
import mods.battlegear2.client.BattlegearClientTickHandeler;
import mods.battlegear2.client.ClientProxy;
import mods.battlegear2.client.gui.BattlegearInGameGUI;
import mods.battlegear2.client.model.QuiverModel;
import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.items.ItemWeapon;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.opengl.GL11;
import xonin.backhand.api.core.BackhandUtils;

public final class BattlegearClientEvents {
    private final BattlegearInGameGUI inGameGUI = new BattlegearInGameGUI();
    private final QuiverModel quiverModel = new QuiverModel();
    private final ResourceLocation quiverDetails = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverDetails.png");
    private final ResourceLocation quiverBase = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverBase.png");
    public static final BattlegearClientEvents INSTANCE = new BattlegearClientEvents();
    private static final int SKELETON_ARROW = 5;

    private BattlegearClientEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderQuiver(RenderItemBarEvent.QuiverSlots event) {
        event.xOffset += BattlegearConfig.quiverBarOffset[0];
        event.yOffset += BattlegearConfig.quiverBarOffset[1];
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderShield(RenderItemBarEvent.ShieldBar event) {
        event.xOffset += BattlegearConfig.shieldBarOffset[0];
        event.yOffset += BattlegearConfig.shieldBarOffset[1];
    }

    @SubscribeEvent(receiveCanceled=true)
    public void postRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR && (BattlegearConfig.forceHUD || !event.isCanceled())) {
            this.inGameGUI.renderGameOverlay(event.partialTicks, event.mouseX, event.mouseY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderPlayerLeftItemUsage(RenderLivingEvent.Pre event) {
        RendererLivingEntity rendererLivingEntity;
        EntityPlayer entityPlayer;
        ItemStack offhand;
        EntityLivingBase entityLivingBase = event.entity;
        if (entityLivingBase instanceof EntityPlayer && (offhand = BackhandUtils.getOffhandItem((EntityPlayer)(entityPlayer = (EntityPlayer)entityLivingBase))) != null && (rendererLivingEntity = event.renderer) instanceof RenderPlayer) {
            RenderPlayer renderer = (RenderPlayer)rendererLivingEntity;
            if (((IBattlePlayer)entityPlayer).battlegear2$isBlockingWithShield()) {
                renderer.field_77109_a.field_78119_l = 3;
                renderer.field_77111_i.field_78119_l = 3;
                renderer.field_77108_b.field_78119_l = 3;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void resetPlayerLeftHand(RenderPlayerEvent.Post event) {
        event.renderer.field_77109_a.field_78119_l = 0;
        event.renderer.field_77111_i.field_78119_l = 0;
        event.renderer.field_77108_b.field_78119_l = 0;
    }

    @SubscribeEvent
    public void render3rdPersonBattlemode(RenderPlayerEvent.Specials.Post event) {
        ModelBiped biped = (ModelBiped)event.renderer.field_77045_g;
        BattlegearRenderHelper.renderItemIn3rdPerson(event.entityPlayer, biped, event.partialRenderTick);
        ItemStack quiverStack = QuiverArrowRegistry.getArrowContainer(event.entityPlayer);
        if (quiverStack != null && ((IArrowContainer2)quiverStack.func_77973_b()).renderDefaultQuiverModel(quiverStack)) {
            IArrowContainer2 quiver = (IArrowContainer2)quiverStack.func_77973_b();
            int maxStack = quiver.getSlotCount(quiverStack);
            int arrowCount = 0;
            for (int i = 0; i < maxStack; ++i) {
                arrowCount += quiver.getStackInSlot(quiverStack, i) == null ? 0 : 1;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverDetails);
            GL11.glPushMatrix();
            if (event.entityPlayer.func_71124_b(3) != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0625f);
            }
            biped.field_78115_e.func_78794_c(0.0625f);
            GL11.glScalef((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(arrowCount, 0.0625f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverBase);
            if (quiverStack.func_77973_b() instanceof IDyable) {
                int col = ((IDyable)((Object)quiver)).getColor(quiverStack);
                float red = (float)(col >> 16 & 0xFF) / 255.0f;
                float green = (float)(col >> 8 & 0xFF) / 255.0f;
                float blue = (float)(col & 0xFF) / 255.0f;
                GL11.glColor3f((float)red, (float)green, (float)blue);
            }
            this.quiverModel.render(0, 0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void renderLiving(RenderLivingEvent.Post event) {
        if (BattlegearConfig.enableSkeletonQuiver && event.entity instanceof EntitySkeleton && event.renderer instanceof RenderSkeleton) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverDetails);
            double d0 = ((EntitySkeleton)event.entity).field_70142_S + (((EntitySkeleton)event.entity).field_70165_t - ((EntitySkeleton)event.entity).field_70142_S) * (double)BattlegearClientTickHandeler.getPartialTick();
            double d1 = ((EntitySkeleton)event.entity).field_70137_T + (((EntitySkeleton)event.entity).field_70163_u - ((EntitySkeleton)event.entity).field_70137_T) * (double)BattlegearClientTickHandeler.getPartialTick();
            double d2 = ((EntitySkeleton)event.entity).field_70136_U + (((EntitySkeleton)event.entity).field_70161_v - ((EntitySkeleton)event.entity).field_70136_U) * (double)BattlegearClientTickHandeler.getPartialTick();
            GL11.glTranslatef((float)((float)(d0 - RenderManager.field_78725_b)), (float)((float)(d1 - RenderManager.field_78726_c)), (float)((float)(d2 - RenderManager.field_78723_d)));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            float f2 = this.interpolateRotation(event.entity.field_70760_ar, event.entity.field_70761_aq, 0.0f);
            GL11.glRotatef((float)(180.0f - f2), (float)0.0f, (float)1.0f, (float)0.0f);
            if (event.entity.field_70725_aQ > 0) {
                float f3 = ((float)event.entity.field_70725_aQ + BattlegearClientTickHandeler.getPartialTick() - 1.0f) / 20.0f * 1.6f;
                if ((f3 = MathHelper.func_76129_c((float)f3)) > 1.0f) {
                    f3 = 1.0f;
                }
                GL11.glRotatef((float)(-f3 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            GL11.glRotatef((float)event.entity.field_70125_A, (float)0.0f, (float)1.0f, (float)0.0f);
            if (event.entity.func_71124_b(3) != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0625f);
            }
            ((ModelBiped)event.renderer.field_77045_g).field_78115_e.func_78794_c(0.0625f);
            GL11.glScalef((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(5, 0.0625f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.quiverBase);
            GL11.glColor3f((float)0.1f, (float)0.1f, (float)0.1f);
            this.quiverModel.render(0, 0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onBowFOV(FOVUpdateEvent event) {
        ItemStack stack = event.entity.func_71011_bu();
        if (EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.bowCharge, stack) > 0) {
            int i = event.entity.func_71057_bx();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.newfov /= 1.0f - f1 * 0.15f;
        }
    }

    public float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    @SubscribeEvent
    public void preStitch(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            int i;
            ClientProxy.backgroundIcon = new IIcon[]{event.map.func_94245_a("battlegear2:slots/mainhand"), event.map.func_94245_a("battlegear2:slots/offhand")};
            ClientProxy.bowIcons = new IIcon[3];
            for (i = 0; i < ClientProxy.bowIcons.length; ++i) {
                ClientProxy.bowIcons[i] = event.map.func_94245_a("battlegear2:bow_pulling_" + i);
            }
            ClientProxy.bowIronIcons = new IIcon[3];
            for (i = 0; i < ClientProxy.bowIronIcons.length; ++i) {
                ClientProxy.bowIronIcons[i] = event.map.func_94245_a("battlegear2:bow.iron_pulling_" + i);
            }
            ClientProxy.bowDiamondIcons = new IIcon[3];
            for (i = 0; i < ClientProxy.bowDiamondIcons.length; ++i) {
                ClientProxy.bowDiamondIcons[i] = event.map.func_94245_a("battlegear2:bow.diamond_pulling_" + i);
            }
        }
    }

    @SubscribeEvent
    public void onUpdateFOV(FOVUpdateEvent event) {
        float fov = event.fov;
        if (event.entity.func_71039_bw() && (event.entity.func_71011_bu().func_77973_b() == BattlegearConfig.mobBowIron || event.entity.func_71011_bu().func_77973_b() == BattlegearConfig.modBowDiamond)) {
            int duration = event.entity.func_71057_bx();
            float multiplier = (float)duration / 10.0f;
            multiplier = multiplier > 1.0f ? 1.0f : (multiplier *= multiplier);
            fov *= 1.0f - multiplier * 0.3f;
        }
        event.newfov = fov;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.itemStack.func_77973_b() instanceof IPenetrateWeapon || event.itemStack.func_77973_b() instanceof IHitTimeModifier || event.itemStack.func_77973_b() instanceof IExtendedReachWeapon) {
            for (String txt : event.toolTip) {
                if (!txt.startsWith(EnumChatFormatting.BLUE.toString()) || !txt.contains(StatCollector.func_74838_a((String)("attribute.name." + ItemWeapon.armourPenetrate.func_111108_a()))) && !txt.contains(StatCollector.func_74838_a((String)("attribute.name." + ItemWeapon.attackSpeed.func_111108_a()))) && !txt.contains(StatCollector.func_74838_a((String)("attribute.name." + ItemWeapon.extendedReach.func_111108_a())))) continue;
                event.toolTip.set(event.toolTip.indexOf(txt), EnumChatFormatting.DARK_GREEN + EnumChatFormatting.func_110646_a((String)txt));
            }
        }
        if (event.itemStack.func_77973_b() instanceof IBackStabbable) {
            event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"attribute.name.weapon.backstab"));
        }
    }
}

