/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.CustomInteractable;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.ComponentDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipLine;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.CircuitLine;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.CircuitLineHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.CircuitRecipe;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.GregTechCircuits;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.LabelHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.util.ComponentTransformer;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Consumer;

class DiagramFactory {
    private final CircuitLineHandler circuitLineHandler;
    private final LabelHandler labelHandler;
    private final LayoutHandler layoutHandler;
    private final RecipeHandler recipeHandler;

    DiagramFactory(CircuitLineHandler circuitLineHandler, LabelHandler labelHandler, LayoutHandler layoutHandler, RecipeHandler recipeHandler) {
        this.circuitLineHandler = circuitLineHandler;
        this.labelHandler = labelHandler;
        this.layoutHandler = layoutHandler;
        this.recipeHandler = recipeHandler;
    }

    Diagram buildOverviewDiagram() {
        Diagram.Builder diagramBuilder = Diagram.builder().addLayout(this.layoutHandler.overviewLayout());
        Diagram.Builder.SlotGroupManualSubBuilder circuitLinesSlotSubBuilder = diagramBuilder.manualInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.CIRCUIT_LINES);
        ImmutableList<CircuitLine> circuitLines = this.circuitLineHandler.circuitLines();
        for (int i = 0; i < circuitLines.size(); ++i) {
            CircuitLine circuitLine = (CircuitLine)circuitLines.get(i);
            if (!circuitLine.boards().isEmpty()) {
                circuitLinesSlotSubBuilder.insertIntoSlot(i, 0, ComponentTransformer.transformToDisplay(circuitLine.boards()));
            }
            for (int j = 0; j < circuitLine.circuits().size(); ++j) {
                circuitLinesSlotSubBuilder.insertIntoSlot(i, circuitLine.startTier() + j + 1, DiagramFactory.buildCircuitDisplayComponent(circuitLine, j));
            }
        }
        Diagram.Builder.SlotGroupManualSubBuilder individualCircuitsSlotSubBuilder = diagramBuilder.manualInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.INDIVIDUAL_CIRCUITS);
        circuitLines = this.circuitLineHandler.individualCircuits();
        for (int i = 0; i < circuitLines.size(); ++i) {
            CircuitLine circuitLine = (CircuitLine)circuitLines.get(i);
            Preconditions.checkState((circuitLine.circuits().size() == 1 ? 1 : 0) != 0, (String)"Expected individual circuit: %s", (Object[])new Object[]{circuitLine});
            if (!circuitLine.boards().isEmpty()) {
                individualCircuitsSlotSubBuilder.insertIntoSlot(i, 0, ComponentTransformer.transformToDisplay(circuitLine.boards()));
            }
            individualCircuitsSlotSubBuilder.insertIntoSlot(i, 1, DiagramFactory.buildCircuitDisplayComponent(circuitLine, 0));
        }
        Diagram.Builder.SlotGroupManualSubBuilder circuitPartsSlotSubBuilder = diagramBuilder.manualInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.CIRCUIT_PARTS);
        ImmutableList<ImmutableList<ItemComponent>> circuitParts = this.circuitLineHandler.circuitParts();
        for (int i = 0; i < circuitParts.size(); ++i) {
            ImmutableList circuitPartsSubList = (ImmutableList)circuitParts.get(i);
            for (int j = 0; j < circuitPartsSubList.size(); ++j) {
                circuitPartsSlotSubBuilder.insertIntoSlot(i, j, ComponentTransformer.transformToDisplay((Component)circuitPartsSubList.get(j)));
            }
        }
        return diagramBuilder.build();
    }

    void buildDiagrams(ItemComponent circuit, ComponentDiagramMatcher.Builder matcherBuilder) {
        ImmutableList<CircuitRecipe> recipes = this.recipeHandler.getCircuitAssemblingMachineRecipes(circuit);
        if (recipes.isEmpty()) {
            this.buildDiagram(circuit, 0, 0, Optional.empty(), matcherBuilder);
        } else {
            int recipeCount = recipes.size();
            for (int i = 0; i < recipeCount; ++i) {
                this.buildDiagram(circuit, i, recipeCount, Optional.of(recipes.get(i)), matcherBuilder);
            }
        }
    }

    void buildDiagram(ItemComponent circuit, int recipeIndex, int recipeCount, Optional<CircuitRecipe> recipeOptional, ComponentDiagramMatcher.Builder matcherBuilder) {
        Diagram.Builder diagramBuilder = Diagram.builder().addAllLayouts((Iterable<Layout>)this.layoutHandler.requiredLayouts()).addAllOptionalLayouts((Iterable<Layout>)this.layoutHandler.optionalLayouts());
        HashSet craftingComponents = Sets.newHashSet((Object[])new Component[]{circuit});
        HashSet usageComponents = Sets.newHashSet((Object[])new Component[]{circuit});
        if (this.recipeHandler.hasCraftingTableRecipes(circuit)) {
            diagramBuilder.addInteractable(this.labelHandler.buildLabel(LabelHandler.ItemLabel.CRAFTING_TABLE, LayoutHandler.AdditionalRecipeLabelPositions.CRAFTING_TABLE));
        }
        if (this.recipeHandler.hasAssemblingMachineRecipes(circuit)) {
            diagramBuilder.addInteractable(this.labelHandler.buildLabel(LabelHandler.ItemLabel.ASSEMBLING_MACHINE, LayoutHandler.AdditionalRecipeLabelPositions.ASSEMBLING_MACHINE));
        }
        if (this.recipeHandler.hasAssemblingLineRecipes(circuit)) {
            diagramBuilder.addInteractable(this.labelHandler.buildLabel(LabelHandler.ItemLabel.ASSEMBLING_LINE, LayoutHandler.AdditionalRecipeLabelPositions.ASSEMBLING_LINE));
        }
        CircuitLineHandler.CircuitLineCircuits circuitLineCircuits = this.circuitLineHandler.circuitLineCircuits(circuit);
        Diagram.Builder.SlotGroupManualSubBuilder circuitLineCircuitsSlotSubBuilder = diagramBuilder.manualInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.CIRCUIT_LINE_CIRCUITS);
        circuitLineCircuits.previousCircuit().ifPresent(previousCircuit -> circuitLineCircuitsSlotSubBuilder.insertIntoSlot(0, 0, (DisplayComponent)previousCircuit));
        circuitLineCircuits.currentCircuit().ifPresent(currentCircuit -> circuitLineCircuitsSlotSubBuilder.insertIntoSlot(1, 0, (DisplayComponent)currentCircuit));
        circuitLineCircuits.nextCircuit().ifPresent(nextCircuit -> circuitLineCircuitsSlotSubBuilder.insertIntoSlot(2, 0, (DisplayComponent)nextCircuit));
        diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.TIER_CIRCUITS).insertEachSafe((Iterable<DisplayComponent>)this.circuitLineHandler.tierCircuits(circuit));
        if (recipeOptional.isPresent()) {
            CircuitRecipe recipe = recipeOptional.get();
            CustomInteractable baseLabel = this.labelHandler.buildLabel(LabelHandler.ItemLabel.CIRCUIT_ASSEMBLING_MACHINE, LayoutHandler.AdditionalRecipeLabelPositions.CIRCUIT_ASSEMBLING_MACHINE);
            Tooltip.Builder tooltipBuilder = Tooltip.builder().addAllLines((Iterable<TooltipLine>)baseLabel.tooltip().lines()).addSpacing().addTextLine(Lang.GREGTECH_5_CIRCUITS.transf("recipeindexlabel", recipeIndex + 1, recipeCount));
            Consumer<Point> drawForeground = position -> {};
            if (recipe.missingCombinations()) {
                tooltipBuilder.addSpacing().setFormatting(Tooltip.URGENT_FORMATTING).addTextLine(Lang.GREGTECH_5_CIRCUITS.trans("missingcombinationslabel"));
                drawForeground = position -> Draw.drawTextOverIcon("*", position, Grid.Direction.NW, -65536, true, true);
            }
            diagramBuilder.addInteractable(CustomInteractable.builder(baseLabel.drawable()).setTooltip(tooltipBuilder.build()).setDrawForeground(drawForeground).build());
            if (recipe.requiresCleanroom()) {
                diagramBuilder.addInteractable(this.labelHandler.buildLabel(LabelHandler.ItemLabel.CLEAN_ROOM, LayoutHandler.AdditionalRecipeLabelPositions.CLEAN_ROOM));
            }
            if (recipe.requiresLowGravity()) {
                diagramBuilder.addInteractable(this.labelHandler.buildLabel(LabelHandler.ItemLabel.LOW_GRAVITY, LayoutHandler.AdditionalRecipeLabelPositions.LOW_GRAVITY));
            }
            ImmutableList<ImmutableSortedSet<DisplayComponent>> itemInputs = recipe.itemInputs();
            for (int i = 0; i < itemInputs.size(); ++i) {
                ImmutableSortedSet subItemInputs = (ImmutableSortedSet)itemInputs.get(i);
                diagramBuilder.autoInsertIntoSlotGroup((Layout.SlotGroupKey)LayoutHandler.SLOT_GROUP_RECIPE_ITEM_INPUTS.get(i)).insertEachSafe((Iterable<DisplayComponent>)subItemInputs);
                subItemInputs.stream().map(DisplayComponent::component).flatMap(c -> GregTechOreDictUtil.getAssociatedComponents(c).stream()).forEach(usageComponents::add);
            }
            ImmutableSortedSet<DisplayComponent> fluidInputs = recipe.fluidInputs();
            diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.RECIPE_FLUID_INPUTS).insertEachSafe((Iterable<DisplayComponent>)fluidInputs);
            fluidInputs.stream().map(DisplayComponent::component).forEach(usageComponents::add);
            diagramBuilder.insertIntoSlot(LayoutHandler.SlotKeys.RECIPE_OUTPUT, recipe.output());
        }
        matcherBuilder.addDiagram(diagramBuilder.build()).addAllComponents(Interactable.RecipeType.CRAFTING, craftingComponents).addAllComponents(Interactable.RecipeType.USAGE, usageComponents);
    }

    static DisplayComponent buildCircuitDisplayComponent(CircuitLine circuitLine, int index) {
        return GregTechCircuits.buildCircuitDisplayComponent((ItemComponent)circuitLine.circuits().get(index), circuitLine.startTier() + index);
    }
}

