/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.core.blocks.BlockSoil;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.CropPeat;
import forestry.farming.logic.FarmLogicWatered;
import forestry.plugins.PluginCore;
import java.util.ArrayDeque;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FarmLogicPeat
extends FarmLogicWatered {
    private static final ItemStack bogEarth = PluginCore.blocks.soil.get(BlockSoil.SoilType.BOG_EARTH, 1);

    public FarmLogicPeat(IFarmHousing housing) {
        super(housing, bogEarth, bogEarth);
    }

    @Override
    public boolean isAcceptedGround(ItemStack itemStack) {
        if (super.isAcceptedGround(itemStack)) {
            return true;
        }
        Block block = BlockSoil.func_149634_a((Item)itemStack.func_77973_b());
        if (!(block instanceof BlockSoil)) {
            return false;
        }
        BlockSoil blockSoil = (BlockSoil)block;
        BlockSoil.SoilType soilType = blockSoil.getTypeFromMeta(itemStack.func_77960_j());
        return soilType == BlockSoil.SoilType.BOG_EARTH || soilType == BlockSoil.SoilType.PEAT;
    }

    @Override
    public int getFertilizerConsumption() {
        return 2;
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Peat Bog";
        }
        return "Managed Peat Bog";
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        ArrayDeque<ICrop> crops = new ArrayDeque<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockSoil blockSoil;
            BlockSoil.SoilType soilType;
            Block block;
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            ItemStack occupant = VectUtil.getAsItemStack(world, position);
            if (occupant.func_77973_b() == null || !((block = Block.func_149634_a((Item)occupant.func_77973_b())) instanceof BlockSoil) || (soilType = (blockSoil = (BlockSoil)block).getTypeFromMeta(occupant.func_77960_j())) != BlockSoil.SoilType.PEAT) continue;
            crops.push(new CropPeat(world, position));
        }
        return crops;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return PluginCore.items.peat.func_77617_a(0);
    }
}

