/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;

public class EzNBT {
    private static EzNBT NOTHING = new EzNBT((NBTBase)null);
    protected final Optional<NBTBase> base;
    protected final Kind kind;

    public EzNBT(NBTBase base) {
        this.base = Optional.ofNullable(base);
        this.kind = Kind.determine(base).orElseThrow(() -> new IllegalArgumentException("Unknow NBT Tag Type: " + base.func_74732_a()));
    }

    public EzNBT(ItemStack stack) {
        this((NBTBase)stack.func_77978_p());
    }

    public EzNBT get(String key) {
        if (this.kind != Kind.COMPOUND) {
            return NOTHING;
        }
        return new EzNBT(this.asCompound().get().func_74781_a(key));
    }

    public Optional<String> valueString() {
        if (this.kind != Kind.STRING) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.asString().get().func_150285_a_());
    }

    public Optional<String> getString(String key) {
        if (this.kind != Kind.COMPOUND) {
            return Optional.empty();
        }
        NBTTagCompound compound = this.asCompound().get();
        if (!compound.func_74764_b(key)) {
            return Optional.empty();
        }
        return Optional.of(compound.func_74779_i(key));
    }

    public Optional<Integer> valueInteger() {
        if (this.kind != Kind.STRING) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.asInteger().get().func_150287_d());
    }

    public Optional<Integer> getInteger(String key) {
        if (this.kind != Kind.COMPOUND) {
            return Optional.empty();
        }
        NBTTagCompound compound = this.asCompound().get();
        if (!compound.func_74764_b(key)) {
            return Optional.empty();
        }
        return Optional.of(compound.func_74762_e(key));
    }

    public boolean hasAll(String ... keys) {
        if (this.kind != Kind.COMPOUND || keys.length == 0) {
            return false;
        }
        NBTTagCompound self = this.asCompound().get();
        for (String tested : keys) {
            if (self.func_74764_b(tested)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAny(String ... keys) {
        if (this.kind != Kind.COMPOUND || keys.length == 0) {
            return false;
        }
        NBTTagCompound self = this.asCompound().get();
        for (String tested : keys) {
            if (!self.func_74764_b(tested)) continue;
            return true;
        }
        return false;
    }

    public boolean isPresent() {
        return this.base.isPresent();
    }

    public boolean isEmpty() {
        return !this.isPresent();
    }

    public void ifPresent(Consumer<NBTTagCompound> fn) {
        if (this.isPresent()) {
            if (this.kind != Kind.COMPOUND) {
                String msg = String.format("The tag is present but has an incorrect type. Expected: {}, found: {}", Kind.COMPOUND.name(), this.kind.name());
                throw new IllegalArgumentException(msg);
            }
            fn.accept((NBTTagCompound)this.base.get());
        }
    }

    public boolean hasKey(String key) {
        if (this.kind != Kind.COMPOUND) {
            return false;
        }
        return this.asCompound().get().func_74764_b(key);
    }

    public Optional<NBTTagCompound> asCompound() {
        if (this.kind != Kind.COMPOUND) {
            return Optional.empty();
        }
        return this.base.map(it -> (NBTTagCompound)it);
    }

    public Optional<NBTTagString> asString() {
        if (this.kind != Kind.STRING) {
            return Optional.empty();
        }
        return this.base.map(it -> (NBTTagString)it);
    }

    public Optional<NBTTagInt> asInteger() {
        if (this.kind != Kind.INT) {
            return Optional.empty();
        }
        return this.base.map(it -> (NBTTagInt)it);
    }

    public static enum Kind {
        NOTHING(-1, "NOTHING"),
        END(0, NBTBase.field_82578_b[0]),
        BYTE(1, NBTBase.field_82578_b[1]),
        SHORT(2, NBTBase.field_82578_b[2]),
        INT(3, NBTBase.field_82578_b[3]),
        LONG(4, NBTBase.field_82578_b[4]),
        FLOAT(5, NBTBase.field_82578_b[5]),
        DOUBLE(6, NBTBase.field_82578_b[6]),
        BYTE_ARRAY(7, NBTBase.field_82578_b[7]),
        STRING(8, NBTBase.field_82578_b[8]),
        LIST(9, NBTBase.field_82578_b[9]),
        COMPOUND(10, NBTBase.field_82578_b[10]),
        INT_ARRAY(11, NBTBase.field_82578_b[11]);

        private int id;
        private String _name;

        static Optional<Kind> determine(NBTBase base) {
            if (base == null) {
                return Optional.of(NOTHING);
            }
            byte baseId = base.func_74732_a();
            return Stream.of(Kind.values()).filter(it -> it.getId() == baseId).findAny();
        }

        private Kind(int id, String name) {
            this.id = id;
            this._name = name;
        }

        int getId() {
            return this.id;
        }

        String getName() {
            return this._name;
        }
    }
}

