/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableDouble
extends SyncableObjectBase
implements ISyncableValueProvider<Double> {
    private double value;

    public SyncableDouble(double value) {
        this.value = value;
    }

    public SyncableDouble() {
    }

    public void set(double newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public double get() {
        return this.value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = stream.readDouble();
    }

    @Override
    public void writeToStream(DataOutputStream stream) throws IOException {
        stream.writeDouble(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74780_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74769_h(name);
    }

    public void modify(float by) {
        this.set(this.value + (double)by);
    }
}

