/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.structurenbt;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class BlockStateContainer {
    private final Object theObject;
    private NBTTagCompound theCompound;
    private final BlockStateType type;
    private int theMeta;
    private ChestGenHooks lootTable;

    public BlockStateContainer(Block block, int meta, ChestGenHooks info) {
        this(block, meta);
        this.setLootTable(info);
    }

    public BlockStateContainer(Block block, int meta) {
        this.theObject = block;
        this.theMeta = meta;
        this.type = block instanceof ITileEntityProvider ? BlockStateType.BLOCK_ENTITY : BlockStateType.BLOCK;
    }

    public BlockStateContainer(Block block) {
        this(block, 0);
    }

    public BlockStateContainer(Class<? extends Entity> entity, NBTTagCompound compound) {
        this.theObject = entity;
        this.theCompound = compound;
        this.type = BlockStateType.ENTITY;
    }

    public BlockStateContainer(Class<? extends Entity> entity) {
        this(entity, new NBTTagCompound());
    }

    public Block getBlock() {
        if (this.type == BlockStateType.ENTITY) {
            throw new IllegalArgumentException("Tried to get block instance from ENTITY in a BlockState object!");
        }
        return (Block)this.theObject;
    }

    public int getMeta() {
        if (this.type == BlockStateType.ENTITY) {
            throw new IllegalArgumentException("Tried to get metadata from ENTITY in a BlockState object!");
        }
        return this.theMeta;
    }

    public Entity createNewEntity(World world) {
        if (this.type != BlockStateType.ENTITY) {
            throw new IllegalArgumentException("Tried to get entity instance from a block in a BlockState object!");
        }
        return EntityList.func_75620_a((String)((String)EntityList.field_75626_c.get(this.theObject)), (World)world);
    }

    public BlockStateType getType() {
        return this.type;
    }

    public NBTTagCompound getCompound() {
        return this.theCompound;
    }

    public void setCompound(NBTTagCompound blockTags) {
        this.theCompound = blockTags;
    }

    public ChestGenHooks getLootTable() {
        if (!(this.type == BlockStateType.BLOCK_ENTITY || this.type == BlockStateType.ENTITY && this.theObject.getClass().isInstance(IInventory.class))) {
            throw new IllegalArgumentException("Tried to get a loot table from a non-entity block!");
        }
        return this.lootTable;
    }

    public void setLootTable(ChestGenHooks info) {
        if (!(this.type == BlockStateType.BLOCK_ENTITY || this.type == BlockStateType.ENTITY && this.theObject.getClass().isInstance(IInventory.class))) {
            throw new IllegalArgumentException("Tried to set a loot table from a non-entity block!");
        }
        this.lootTable = info;
    }

    public static enum BlockStateType {
        BLOCK,
        BLOCK_ENTITY,
        ENTITY;

    }
}

