/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.botany.api.IFlower;
import binnie.core.AbstractMod;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.Widget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.scroll.ControlScrollBar;
import binnie.core.craftgui.controls.scroll.ControlScrollableContent;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventKey;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.minecraft.InventoryType;
import binnie.core.craftgui.minecraft.MinecraftGUI;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.core.craftgui.minecraft.control.ControlSlide;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.craftgui.window.Panel;
import binnie.core.genetics.BreedingSystem;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import binnie.genetics.gui.AnalystPageAppearance;
import binnie.genetics.gui.AnalystPageBehaviour;
import binnie.genetics.gui.AnalystPageBiology;
import binnie.genetics.gui.AnalystPageClimate;
import binnie.genetics.gui.AnalystPageDatabase;
import binnie.genetics.gui.AnalystPageDescription;
import binnie.genetics.gui.AnalystPageFruit;
import binnie.genetics.gui.AnalystPageGenome;
import binnie.genetics.gui.AnalystPageGrowth;
import binnie.genetics.gui.AnalystPageKaryogram;
import binnie.genetics.gui.AnalystPageMutations;
import binnie.genetics.gui.AnalystPageProducts;
import binnie.genetics.gui.AnalystPageSoil;
import binnie.genetics.gui.AnalystPageSpecimen;
import binnie.genetics.gui.AnalystPageWood;
import binnie.genetics.gui.ControlAnalystPage;
import binnie.genetics.gui.ControlTooltip;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.analyser.Analyser;
import cpw.mods.fml.relauncher.Side;
import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.IButterfly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;

public class WindowAnalyst
extends Window {
    protected IWidget baseWidget = null;
    protected ControlScrollableContent leftPage;
    protected ControlScrollableContent rightPage;
    protected Control tabBar = null;
    protected Panel analystPanel;
    protected List<ControlAnalystPage> analystPages = new ArrayList<ControlAnalystPage>();
    protected IArea analystPageSize = null;
    protected boolean isDatabase = false;
    protected boolean isMaster = false;
    protected boolean lockedSearch = false;
    protected IIndividual current = null;
    protected BreedingSystem currentSystem = null;
    private Control analystNone;
    private ControlSlide slideUpInv;

    public WindowAnalyst(EntityPlayer player, IInventory inventory, Side side, boolean database, boolean master) {
        super(312.0f, 230.0f, player, inventory, side);
        this.isDatabase = database;
        this.isMaster = master;
        this.lockedSearch = this.isDatabase;
    }

    @Override
    protected AbstractMod getMod() {
        return Genetics.instance;
    }

    @Override
    protected String getName() {
        return "Analyst";
    }

    private void setupValidators() {
        if (!this.isDatabase) {
            this.getWindowInventory().setValidator(0, new SlotValidator.Individual(){

                @Override
                public boolean isValid(ItemStack itemStack) {
                    return Analyser.isAnalysed(itemStack) || Analyser.isAnalysable(itemStack) && WindowAnalyst.this.getWindowInventory().func_70301_a(1) != null;
                }
            });
            this.getWindowInventory().setValidator(1, new SlotValidator.Item(GeneticsItems.DNADye.get(1), ModuleMachine.IconDye));
        }
    }

    @Override
    public void initialiseServer() {
        for (BreedingSystem system : Binnie.Genetics.getActiveSystems()) {
            IBreedingTracker tracker = system.getSpeciesRoot().getBreedingTracker(this.getWorld(), this.getUsername());
            if (tracker == null) continue;
            tracker.synchToPlayer(this.getPlayer());
        }
        this.setupValidators();
    }

    @Override
    public void initialiseClient() {
        if (this.isDatabase) {
            if (this.isMaster) {
                this.setTitle(I18N.localise("genetics.item.registry.1.name"));
            } else {
                this.setTitle(I18N.localise("genetics.item.registry.0.name"));
            }
        } else {
            this.setTitle(I18N.localise("genetics.item.analyst.name"));
        }
        this.getWindowInventory().createSlot(0);
        this.baseWidget = new Widget(this);
        int x = 16;
        int y = 28;
        if (this.isDatabase) {
            for (final BreedingSystem syst : Binnie.Genetics.getActiveSystems()) {
                new Control(this, x, y, 20.0f, 20.0f){

                    @Override
                    public void initialise() {
                        this.addAttribute(WidgetAttribute.MOUSE_OVER);
                        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                            @Override
                            public void onEvent(EventMouse.Down event) {
                                WindowAnalyst.this.setSystem(syst);
                            }
                        });
                    }

                    @Override
                    public void getTooltip(Tooltip tooltip) {
                        tooltip.add(syst.getName());
                    }

                    @Override
                    public void onRenderBackground() {
                        CraftGUI.render.color(syst.getColor());
                        int outset = WindowAnalyst.this.getSystem() == syst ? 1 : 0;
                        CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea().outset(outset));
                        if (WindowAnalyst.this.getSystem() == syst) {
                            CraftGUI.render.color(0x44000000 + syst.getColor());
                            CraftGUI.render.texture((Object)CraftGUITexture.TabSolid, this.getArea().outset(outset));
                        }
                        CraftGUI.render.item(new IPoint(2.0f, 2.0f), syst.getItemStackRepresentative());
                    }
                };
                x += 22;
            }
        } else {
            NBTTagList actions = new NBTTagList();
            new ControlSlot(this, x, y + 1).assign(actions, InventoryType.Window, 0);
            new ControlSlot(this, x += 22, y + 1).assign(actions, InventoryType.Window, 1);
            x += 26;
            this.setupValidators();
            MessageCraftGUI.sendToServer(actions);
        }
        this.tabBar = new Control(this, x, 28.0f, this.w() - 16.0f - (float)x, 20.0f);
        this.analystPanel = new Panel(this, 16.0f, 54.0f, 280.0f, 164.0f, MinecraftGUI.PanelType.Outline){

            @Override
            public void onRenderBackground() {
                CraftGUI.render.gradientRect(this.getArea(), 0x44FFFFFF, 0x66FFFFFF);
                super.onRenderBackground();
            }

            @Override
            public void initialise() {
                this.setColor(0x444444);
                float sectionWidth = (this.w() - 8.0f - 4.0f) / 2.0f;
                WindowAnalyst.this.leftPage = new ControlScrollableContent<IWidget>((IWidget)this, 3.0f, 3.0f, sectionWidth + 2.0f, this.h() - 8.0f + 2.0f, 0.0f){

                    @Override
                    public void onRenderBackground() {
                        if (this.getContent() == null) {
                            return;
                        }
                        CraftGUI.render.color(this.getContent().getColor());
                        CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                    }
                };
                new ControlScrollBar(this, sectionWidth + 2.0f - 3.0f, 6.0f, 3.0f, this.h() - 8.0f + 2.0f - 6.0f, WindowAnalyst.this.leftPage){

                    @Override
                    public void onRenderBackground() {
                        if (!this.isEnabled()) {
                            return;
                        }
                        if (WindowAnalyst.this.leftPage.getContent() == null) {
                            return;
                        }
                        CraftGUI.render.gradientRect(this.getArea(), 0x44000000 + WindowAnalyst.this.leftPage.getContent().getColor(), 0x44000000 + WindowAnalyst.this.leftPage.getContent().getColor());
                        CraftGUI.render.solid(this.getRenderArea(), WindowAnalyst.this.leftPage.getContent().getColor());
                    }
                };
                WindowAnalyst.this.rightPage = new ControlScrollableContent<IWidget>((IWidget)this, 3.0f + sectionWidth + 4.0f, 3.0f, sectionWidth + 2.0f, this.h() - 8.0f + 2.0f, 0.0f){

                    @Override
                    public void onRenderBackground() {
                        if (this.getContent() == null) {
                            return;
                        }
                        CraftGUI.render.color(this.getContent().getColor());
                        CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                    }
                };
                new ControlScrollBar(this, sectionWidth + 2.0f - 3.0f + sectionWidth + 4.0f, 6.0f, 3.0f, this.h() - 8.0f + 2.0f - 6.0f, WindowAnalyst.this.rightPage){

                    @Override
                    public void onRenderBackground() {
                        if (!this.isEnabled()) {
                            return;
                        }
                        if (WindowAnalyst.this.rightPage.getContent() == null) {
                            return;
                        }
                        CraftGUI.render.gradientRect(this.getArea(), 0x44000000 + WindowAnalyst.this.rightPage.getContent().getColor(), 0x44000000 + WindowAnalyst.this.rightPage.getContent().getColor());
                        CraftGUI.render.solid(this.getRenderArea(), WindowAnalyst.this.rightPage.getContent().getColor());
                    }
                };
                WindowAnalyst.this.analystPageSize = new IArea(1.0f, 1.0f, sectionWidth, this.h() - 8.0f);
            }
        };
        if (!this.isDatabase) {
            this.slideUpInv = new ControlSlide(this, (this.getSize().x() - 244.0f) / 2.0f, this.getSize().y() - 80.0f + 1.0f, 244.0f, 80.0f, Position.BOTTOM);
            new ControlPlayerInventory((IWidget)this.slideUpInv, true);
            this.slideUpInv.setSlide(false);
        }
        this.addEventHandler((EventHandler)new EventKey.Down.Handler(){

            @Override
            public void onEvent(EventKey.Down event) {
                if (event.getKey() == 205) {
                    WindowAnalyst.this.shiftPages(true);
                }
                if (event.getKey() == 203) {
                    WindowAnalyst.this.shiftPages(false);
                }
            }
        });
        if (!this.isDatabase) {
            this.analystNone = new Control(this.analystPanel, 0.0f, 0.0f, this.analystPanel.w(), this.analystPanel.h()){

                @Override
                public void initialise() {
                    new ControlTextCentered((IWidget)this, 20.0f, I18N.localise("genetics.gui.analyst.info")).setColor(0x444444);
                    new ControlPlayerInventory(this);
                }
            };
        }
        this.setIndividual(null);
        this.setSystem(Binnie.Genetics.beeBreedingSystem);
    }

    public void updatePages(boolean systemChange) {
        int oldLeft = -1;
        int oldRight = -1;
        if (!systemChange) {
            oldLeft = this.analystPages.indexOf(this.leftPage.getContent());
            oldRight = this.analystPages.indexOf(this.rightPage.getContent());
        }
        ControlAnalystPage databasePage = null;
        if (this.isDatabase && !systemChange) {
            databasePage = !this.analystPages.isEmpty() ? this.analystPages.get(0) : null;
        }
        this.analystPages.clear();
        this.setPage(this.leftPage, null);
        this.setPage(this.rightPage, null);
        if (this.isDatabase) {
            this.analystPages.add(databasePage != null ? databasePage : new AnalystPageDatabase(this.analystPanel, this.analystPageSize, this.currentSystem, this.isMaster));
        }
        if (this.current != null) {
            this.analystPages.add(new AnalystPageDescription(this.analystPanel, this.analystPageSize, this.current));
            this.analystPages.add(new AnalystPageGenome(this.analystPanel, this.analystPageSize, true, this.current));
            if (!this.isDatabase) {
                this.analystPages.add(new AnalystPageGenome(this.analystPanel, this.analystPageSize, false, this.current));
                this.analystPages.add(new AnalystPageKaryogram(this.analystPanel, this.analystPageSize, this.current));
            }
            if (!(this.current instanceof ITree)) {
                this.analystPages.add(new AnalystPageClimate(this.analystPanel, this.analystPageSize, this.current));
            }
            if (this.current instanceof IBee) {
                this.analystPages.add(new AnalystPageProducts(this.analystPanel, this.analystPageSize, (IBee)this.current));
            } else if (this.current instanceof ITree) {
                this.analystPages.add(new AnalystPageFruit(this.analystPanel, this.analystPageSize, (ITree)this.current));
                this.analystPages.add(new AnalystPageWood(this.analystPanel, this.analystPageSize, (ITree)this.current));
            } else if (this.current instanceof IFlower) {
                this.analystPages.add(new AnalystPageSoil(this.analystPanel, this.analystPageSize, (IFlower)this.current));
            } else if (this.current instanceof IButterfly) {
                this.analystPages.add(new AnalystPageSpecimen(this.analystPanel, this.analystPageSize, (IButterfly)this.current));
            }
            this.analystPages.add(new AnalystPageBiology(this.analystPanel, this.analystPageSize, this.current));
            if (this.current instanceof IBee || this.current instanceof IButterfly) {
                this.analystPages.add(new AnalystPageBehaviour(this.analystPanel, this.analystPageSize, this.current));
            } else if (this.current instanceof ITree) {
                this.analystPages.add(new AnalystPageGrowth(this.analystPanel, this.analystPageSize, this.current));
            } else if (this.current instanceof IFlower) {
                this.analystPages.add(new AnalystPageAppearance(this.analystPanel, this.analystPageSize, (IFlower)this.current));
            }
            this.analystPages.add(new AnalystPageMutations(this.analystPanel, this.analystPageSize, this.current, this.isMaster));
        }
        this.tabBar.deleteAllChildren();
        float width = this.tabBar.w() / (float)this.analystPages.size();
        float x = 0.0f;
        for (final ControlAnalystPage page : this.analystPages) {
            new ControlTooltip(this.tabBar, x, 0.0f, width, this.tabBar.h()){
                ControlAnalystPage value;

                @Override
                public void getTooltip(Tooltip tooltip) {
                    tooltip.add(this.value.getTitle());
                }

                @Override
                protected void initialise() {
                    super.initialise();
                    this.addAttribute(WidgetAttribute.MOUSE_OVER);
                    this.value = page;
                    this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                        @Override
                        public void onEvent(EventMouse.Down event) {
                            int currentIndex = WindowAnalyst.this.analystPages.indexOf(WindowAnalyst.this.rightPage.getContent());
                            int clickedIndex = WindowAnalyst.this.analystPages.indexOf(value);
                            if (WindowAnalyst.this.isDatabase) {
                                if (clickedIndex != 0 && clickedIndex != currentIndex) {
                                    WindowAnalyst.this.setPage(WindowAnalyst.this.rightPage, value);
                                }
                            } else {
                                if (clickedIndex < 0) {
                                    clickedIndex = 0;
                                }
                                if (clickedIndex < currentIndex) {
                                    ++clickedIndex;
                                }
                                WindowAnalyst.this.setPage(WindowAnalyst.this.rightPage, null);
                                WindowAnalyst.this.setPage(WindowAnalyst.this.leftPage, null);
                                WindowAnalyst.this.setPage(WindowAnalyst.this.rightPage, WindowAnalyst.this.analystPages.get(clickedIndex));
                                WindowAnalyst.this.setPage(WindowAnalyst.this.leftPage, WindowAnalyst.this.analystPages.get(clickedIndex - 1));
                            }
                        }
                    });
                }

                @Override
                public void onRenderBackground() {
                    boolean active = this.value == WindowAnalyst.this.leftPage.getContent() || this.value == WindowAnalyst.this.rightPage.getContent();
                    CraftGUI.render.color((active ? -16777216 : 0x44000000) + this.value.getColor());
                    CraftGUI.render.texture((Object)CraftGUITexture.TabSolid, this.getArea().inset(1));
                    CraftGUI.render.color(this.value.getColor());
                    CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea().inset(1));
                    super.onRenderBackground();
                }
            };
            x += width;
        }
        if (!this.analystPages.isEmpty()) {
            this.setPage(this.leftPage, this.analystPages.get(Math.max(oldLeft, 0)));
        }
        if (this.analystPages.size() > 1) {
            this.setPage(this.rightPage, this.analystPages.get(oldRight >= 0 ? oldRight : 1));
        }
    }

    public void shiftPages(boolean right) {
        if (this.analystPages.size() < 2) {
            return;
        }
        int leftIndex = this.analystPages.indexOf(this.leftPage.getContent());
        int rightIndex = this.analystPages.indexOf(this.rightPage.getContent());
        if (right && rightIndex + 1 >= this.analystPages.size()) {
            return;
        }
        if (!this.lockedSearch && !right && leftIndex <= 0) {
            return;
        }
        if (!this.lockedSearch && !right && rightIndex <= 1) {
            return;
        }
        int newRightIndex = rightIndex + (right ? 1 : -1);
        int newLeftIndex = this.lockedSearch ? 0 : newRightIndex - 1;
        float oldRightPercent = 0.0f;
        float oldLeftPercent = 0.0f;
        if (newLeftIndex == rightIndex) {
            oldRightPercent = this.rightPage.getPercentageIndex();
        }
        if (newRightIndex == leftIndex) {
            oldLeftPercent = this.leftPage.getPercentageIndex();
        }
        this.setPage(this.leftPage, null);
        this.setPage(this.rightPage, null);
        this.setPage(this.leftPage, this.analystPages.get(newLeftIndex));
        this.setPage(this.rightPage, this.analystPages.get(newRightIndex));
        this.analystPages.get(newLeftIndex).show();
        if (oldRightPercent != 0.0f) {
            this.leftPage.setPercentageIndex(oldRightPercent);
        }
        if (oldLeftPercent != 0.0f) {
            this.rightPage.setPercentageIndex(oldLeftPercent);
        }
    }

    public void setPage(ControlScrollableContent side, ControlAnalystPage page) {
        ControlAnalystPage existingPage = (ControlAnalystPage)side.getContent();
        if (existingPage != null) {
            existingPage.hide();
            side.setScrollableContent(null);
        }
        if (page != null) {
            page.show();
            side.setScrollableContent(page);
            side.setPercentageIndex(0.0f);
            page.setPosition(side.pos().add(1.0f, 1.0f));
        }
    }

    @Override
    public void onWindowInventoryChanged() {
        IIndividual ind;
        super.onWindowInventoryChanged();
        if (this.getWindowInventory().func_70301_a(0) != null && !Analyser.isAnalysed(this.getWindowInventory().func_70301_a(0))) {
            this.getWindowInventory().func_70299_a(0, Analyser.analyse(this.getWindowInventory().func_70301_a(0)));
            this.getWindowInventory().func_70298_a(1, 1);
        }
        if ((ind = AlleleManager.alleleRegistry.getIndividual(this.getWindowInventory().func_70301_a(0))) != null) {
            ind.getGenome().getSpeciesRoot().getBreedingTracker(this.getWorld(), this.getUsername()).registerBirth(ind);
        }
        if (this.isClient()) {
            this.setStack(this.getWindowInventory().func_70301_a(0));
        }
    }

    public void setStack(ItemStack stack) {
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        this.setIndividual(ind);
    }

    public IIndividual getIndividual() {
        return this.current;
    }

    public void setIndividual(IIndividual ind) {
        boolean systemChange;
        if (!this.isDatabase) {
            if (ind == null) {
                this.analystNone.show();
                this.slideUpInv.hide();
            } else {
                this.analystNone.hide();
                this.slideUpInv.show();
            }
        }
        if (ind == this.current || ind != null && this.current != null && ind.isGeneticEqual(this.current)) {
            return;
        }
        this.current = ind;
        boolean bl = systemChange = this.current != null && ind.getGenome().getSpeciesRoot() != this.getSystem().getSpeciesRoot();
        if (systemChange) {
            this.currentSystem = Binnie.Genetics.getSystem(ind.getGenome().getSpeciesRoot());
        }
        this.updatePages(systemChange);
    }

    public BreedingSystem getSystem() {
        return this.currentSystem;
    }

    public void setSystem(BreedingSystem system) {
        if (system == this.currentSystem) {
            return;
        }
        this.currentSystem = system;
        this.current = null;
        this.updatePages(true);
    }
}

