/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.version;

import appeng.core.AELog;
import appeng.services.version.DoNotCheckVersion;
import appeng.services.version.MissingVersion;
import appeng.services.version.Version;
import appeng.services.version.VersionFetcher;
import appeng.services.version.VersionParser;
import appeng.services.version.exceptions.VersionCheckerException;
import javax.annotation.Nonnull;

public final class ModVersionFetcher
implements VersionFetcher {
    private static final Version EXCEPTIONAL_VERSION = new MissingVersion();
    @Nonnull
    private final String rawModVersion;
    @Nonnull
    private final VersionParser parser;

    public ModVersionFetcher(@Nonnull String rawModVersion, @Nonnull VersionParser parser) {
        this.rawModVersion = rawModVersion;
        this.parser = parser;
    }

    @Override
    public Version get() {
        if (this.rawModVersion.equals("@version@") || this.rawModVersion.contains("pr")) {
            return new DoNotCheckVersion();
        }
        try {
            Version version = this.parser.parse(this.rawModVersion);
            return version;
        }
        catch (VersionCheckerException e) {
            AELog.debug(e);
            return EXCEPTIONAL_VERSION;
        }
    }
}

