/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.eig;

import gregtech.api.util.GTUtility;
import java.util.LinkedList;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.utils.ItemUtils;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeIndustrialGreenhouse;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EIGBucket {
    @Nullable
    protected ItemStack seed;
    protected int seedCount;
    protected ItemStack @Nullable [] supportItems;

    public EIGBucket(@NotNull ItemStack seed, int seedCount, ItemStack[] supportItem) {
        this.seed = seed.func_77946_l();
        this.seed.field_77994_a = 1;
        this.seedCount = seedCount;
        this.supportItems = supportItem;
    }

    public EIGBucket(@NotNull NBTTagCompound nbt) {
        this.seed = ItemUtils.readItemStackFromNBT(nbt.func_74775_l("seed"));
        this.seedCount = nbt.func_74762_e("count");
        if (nbt.func_150297_b("supportItems", 9)) {
            NBTTagList supportItemsNBTList = nbt.func_150295_c("supportItems", 10);
            if (supportItemsNBTList.func_74745_c() > 0) {
                this.supportItems = new ItemStack[supportItemsNBTList.func_74745_c()];
                for (int i = 0; i < supportItemsNBTList.func_74745_c(); ++i) {
                    this.supportItems[i] = ItemUtils.readItemStackFromNBT(supportItemsNBTList.func_150305_b(i));
                }
            } else {
                this.supportItems = null;
            }
        } else {
            this.supportItems = null;
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("type", this.getNBTIdentifier());
        nbt.func_74782_a("seed", (NBTBase)ItemUtils.writeItemStackToNBT(this.seed));
        nbt.func_74768_a("count", this.seedCount);
        if (this.supportItems != null && this.supportItems.length > 0) {
            NBTTagList supportItemNBT = new NBTTagList();
            for (ItemStack supportItem : this.supportItems) {
                supportItemNBT.func_74742_a((NBTBase)ItemUtils.writeItemStackToNBT(supportItem));
            }
            nbt.func_74782_a("supportItems", (NBTBase)supportItemNBT);
        }
        return nbt;
    }

    @NotNull
    public ItemStack getSeedStack() {
        ItemStack copied = this.seed.func_77946_l();
        copied.field_77994_a = this.seedCount;
        return copied;
    }

    public int getSeedCount() {
        return this.seedCount;
    }

    public String getDisplayName() {
        return this.seed.func_82833_r();
    }

    @NotNull
    public String getInfoData() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isValid() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED);
        sb.append("x");
        sb.append(this.getSeedCount());
        sb.append(" ");
        sb.append(this.getDisplayName());
        this.getAdditionalInfoData(sb);
        sb.append(EnumChatFormatting.RESET);
        return sb.toString();
    }

    protected void getAdditionalInfoData(StringBuilder sb) {
    }

    public int tryAddSeed(@NotNull MTEExtremeIndustrialGreenhouse greenhouse, @Nullable ItemStack input, int maxConsume, boolean simulate) {
        if (input == null || input.field_77994_a <= 0) {
            return -2;
        }
        maxConsume = Math.min(maxConsume, input.field_77994_a);
        if (!GTUtility.areStacksEqual(this.seed, input, false)) {
            return 0;
        }
        if (this.supportItems == null || this.supportItems.length == 0) {
            if (!simulate) {
                input.field_77994_a -= maxConsume;
                this.seedCount += maxConsume;
            }
            return maxConsume;
        }
        LinkedList<ItemStack> toConsumeFrom = new LinkedList<ItemStack>();
        for (ItemStack supportItem : this.supportItems) {
            ItemStack otherInput2;
            block8: {
                for (ItemStack otherInput2 : greenhouse.getStoredInputs()) {
                    if (otherInput2 == null || otherInput2.field_77994_a <= 0 || !GTUtility.areStacksEqual(supportItem, otherInput2, false)) continue;
                    break block8;
                }
                return -1;
            }
            maxConsume = Math.min(maxConsume, otherInput2.field_77994_a);
            toConsumeFrom.addLast(otherInput2);
        }
        if (!simulate) {
            input.field_77994_a -= maxConsume;
            for (ItemStack stack : toConsumeFrom) {
                stack.field_77994_a -= maxConsume;
            }
            this.seedCount += maxConsume;
        }
        return maxConsume;
    }

    public ItemStack @Nullable [] tryRemoveSeed(int toRemove, boolean simulate) {
        if ((toRemove = Math.min(this.seedCount, toRemove)) <= 0) {
            return null;
        }
        ItemStack[] ret = new ItemStack[1 + (this.supportItems == null ? 0 : this.supportItems.length)];
        ret[0] = this.seed.func_77946_l();
        ret[0].field_77994_a = toRemove;
        if (this.supportItems != null) {
            for (int i = 0; i < this.supportItems.length; ++i) {
                ret[i + 1] = this.supportItems[i].func_77946_l();
                ret[i + 1].field_77994_a = toRemove;
            }
        }
        if (!simulate) {
            this.seedCount -= toRemove;
        }
        return ret;
    }

    public ItemStack @Nullable [] emptyBucket() {
        if (this.seedCount <= 0) {
            return null;
        }
        ItemStack[] ret = new ItemStack[1 + (this.supportItems == null ? 0 : this.supportItems.length)];
        ret[0] = this.seed.func_77946_l();
        ret[0].field_77994_a = this.seedCount;
        if (this.supportItems != null) {
            for (int i = 0; i < this.supportItems.length; ++i) {
                ret[i + 1] = this.supportItems[i].func_77946_l();
                ret[i + 1].field_77994_a = this.seedCount;
            }
        }
        this.seedCount = 0;
        return ret;
    }

    public boolean isValid() {
        return this.seed != null && this.seedCount > 0;
    }

    protected abstract String getNBTIdentifier();

    public abstract void addProgress(double var1, EIGDropTable var3);

    public abstract boolean revalidate(MTEExtremeIndustrialGreenhouse var1);
}

