/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class MTERefinery
extends GTPPMultiBlockBase<MTERefinery>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<MTERefinery> STRUCTURE_DEFINITION = null;

    public MTERefinery(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTERefinery(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Fuel Refinery";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Fission Fuel Processing Unit").addInfo("Refines fluorides and Uranium into nuclear fuel for the LFTR").addInfo("LFTR Fuel 2 and Fuel 3 have alternative, much more efficient recipes").addInfo("However, they require fission breeding outputs from the LFTR itself").addInfo("Only one Energy Hatch is allowed per Processing Unit").addInfo("All recipe times in this multi are very long, watch out!").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 9, 3, false).addController("Bottom Center").addCasingInfoMin("Hastelloy-X Structural Block", 7, false).addCasingInfoMin("Incoloy-DS Fluid Containment Block", 5, false).addCasingInfoMin("Reactor Shield Casing", 4, false).addCasingInfoMin("Hastelloy-N Sealant Blocks", 17, false).addInputHatch("Base platform", 1).addOutputHatch("Base platform", 1).addMufflerHatch("Base platform", 1).addMaintenanceHatch("Base platform", 1).addEnergyHatch("Base platform", 1).addStructureInfo("Muffler's Tier must be IV+").addStructureInfo("2-4x Input Hatches, 1-2x Output Hatches").addStructureInfo("1x Muffler, 1x Maintenance Hatch, 1x Energy Hatch").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE_GLOW;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_GLOW;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(18);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.fissionFuelProcessingRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic();
    }

    @Override
    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchMuffler && ((MTEHatchMuffler)aMetaTileEntity).mTier >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public IStructureDefinition<MTERefinery> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"   ", " N ", "   "}, {" N ", "NIN", " N "}, {" N ", "NIN", " N "}, {" N ", "NIN", " N "}, {" Z ", "ZIZ", " Z "}, {" N ", "NIN", " N "}, {"XXX", "XXX", "XXX"}, {"X~X", "XXX", "XXX"}})).addElement('X', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTERefinery.class).atLeast(HatchElement.Energy, HatchElement.Maintenance, HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.InputHatch).casingIndex(TAE.GTPP_INDEX(18)).dot(1).build(), GTStructureUtility.buildHatchAdder(MTERefinery.class).atLeast(HatchElement.Muffler).adder(MTERefinery::addMufflerToMachineList).hatchItemFilterAnd(t -> GTStructureUtility.filterByMTETier(6, Integer.MAX_VALUE)).casingIndex(TAE.GTPP_INDEX(18)).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)2))})).addElement('I', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)3)).addElement('N', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)1)).addElement('Z', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)13)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 7, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 7, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        if (this.checkPiece(this.mName, 1, 7, 0) && this.mCasing >= 7 && this.mInputHatches.size() >= 2 && this.mInputHatches.size() <= 4 && !this.mOutputHatches.isEmpty() && this.mOutputHatches.size() <= 2 && this.mMufflerHatches.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() == 1) {
            this.resetRecipeMapForAllInputHatches(this.getRecipeMap());
            return true;
        }
        return false;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiRefinery;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERefinery(this.mName);
    }
}

