/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.modularui2;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.PosGuiData;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public final class MetaTileEntityGuiHandler
extends AbstractUIFactory<PosGuiData> {
    public static final MetaTileEntityGuiHandler INSTANCE = new MetaTileEntityGuiHandler();
    public static final int MAX_INTERACTION_DISTANCE = 64;

    private MetaTileEntityGuiHandler() {
        super("gregtech:mte");
    }

    public static void open(EntityPlayer player, IMetaTileEntity mte) {
        IGregTechTileEntity baseTE = mte.getBaseMetaTileEntity();
        if (baseTE == null || !baseTE.canAccessData()) {
            throw new IllegalArgumentException("Can't open invalid MetaTileEntity GUI!");
        }
        if (player.field_70170_p != baseTE.getWorld()) {
            throw new IllegalArgumentException("MetaTileEntity must be in same dimension as the player!");
        }
        if (!(player instanceof EntityPlayerMP)) {
            throw new IllegalArgumentException("MetaTileEntity GUI must be opened on server side!");
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        if (player instanceof FakePlayer) {
            return;
        }
        PosGuiData data = new PosGuiData(player, baseTE.getXCoord(), (int)baseTE.getYCoord(), baseTE.getZCoord());
        GuiManager.open((UIFactory)INSTANCE, (GuiData)data, (EntityPlayerMP)playerMP);
    }

    @NotNull
    public IGuiHolder<PosGuiData> getGuiHolder(PosGuiData data) {
        IGregTechTileEntity baseTE;
        IGuiHolder guiHolder;
        TileEntity te = data.getTileEntity();
        if (te instanceof IGregTechTileEntity && (guiHolder = this.castGuiHolder((baseTE = (IGregTechTileEntity)te).getMetaTileEntity())) != null) {
            return guiHolder;
        }
        throw new IllegalStateException(String.format("TileEntity at (%s, %s, %s) is not a valid MetaTileEntity!", data.getX(), data.getY(), data.getZ()));
    }

    public boolean canInteractWith(EntityPlayer player, PosGuiData guiData) {
        IGregTechTileEntity baseTE;
        TileEntity tileEntity;
        return super.canInteractWith(player, (GuiData)guiData) && (tileEntity = guiData.getTileEntity()) instanceof IGregTechTileEntity && (baseTE = (IGregTechTileEntity)tileEntity).canAccessData() && guiData.getSquaredDistance((Entity)player) <= 64.0;
    }

    public void writeGuiData(PosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
    }

    @NotNull
    public PosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new PosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a());
    }
}

