/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;

public abstract class MTETieredMachineBlock
extends MetaTileEntity {
    public final byte mTier;
    public final String[] mDescriptionArray;
    public final ITexture[][][] mTextures;

    public MTETieredMachineBlock(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aInvSlotCount);
        String[] stringArray;
        this.mTier = (byte)Math.max(0, Math.min(aTier, 14));
        if (aDescription == null) {
            stringArray = GTValues.emptyStringArray;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = aDescription;
        }
        this.mDescriptionArray = stringArray;
        this.mTextures = GTMod.GT.isClientSide() ? this.getTextureSet(aTextures) : null;
    }

    public MTETieredMachineBlock(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aInvSlotCount);
        this.mTier = (byte)Math.max(0, Math.min(aTier, 15));
        this.mDescriptionArray = aDescription == null ? GTValues.emptyStringArray : aDescription;
        this.mTextures = GTMod.GT.isClientSide() ? this.getTextureSet(aTextures) : null;
    }

    public MTETieredMachineBlock(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aInvSlotCount);
        this.mTier = (byte)aTier;
        this.mDescriptionArray = aDescription == null ? GTValues.emptyStringArray : aDescription;
        this.mTextures = aTextures;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)Math.min(3, this.mTier <= 0 ? 0 : 1 + (this.mTier - 1) / 4);
    }

    @Override
    public long getInputTier() {
        return this.mTier;
    }

    @Override
    public long getOutputTier() {
        return this.mTier;
    }

    @Override
    public String[] getDescription() {
        return this.mDescriptionArray;
    }

    public abstract ITexture[][][] getTextureSet(ITexture[] var1);

    protected SlotWidget createChargerSlot(int x, int y) {
        Object[] batterySlotTooltipArgs;
        String batterySlotTooltipKey;
        String pTier1 = GTUtility.getColoredTierNameFromTier(this.mTier);
        if (this.mTier == GTValues.VN.length - 1) {
            batterySlotTooltipKey = "GT5U.machines.battery_slot.tooltip.alternative";
            batterySlotTooltipArgs = new String[]{pTier1};
        } else {
            batterySlotTooltipKey = "GT5U.machines.battery_slot.tooltip";
            batterySlotTooltipArgs = new String[]{pTier1, GTUtility.getColoredTierNameFromTier((byte)(this.mTier + 1))};
        }
        return this.createChargerSlot(x, y, batterySlotTooltipKey, batterySlotTooltipArgs);
    }

    protected SlotWidget createChargerSlot(int x, int y, String tooltipKey, Object[] tooltipArgs) {
        return (SlotWidget)new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.rechargerSlotStartIndex()).disableShiftInsert().setGTTooltip(() -> this.mTooltipCache.getData(tooltipKey, tooltipArgs)).setTooltipShowUpDelay(5).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_CHARGER}).setPos(x, y);
    }
}

