/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockFramingTable
extends BlockContainer {
    public static final int[][] leftOffset = new int[][]{{0, 0}, {0, 0}, {1, 0}, {-1, 0}, {0, -1}, {0, 1}};
    public static final int[][] rightOffset = new int[][]{{0, 0}, {0, 0}, {-1, 0}, {1, 0}, {0, 1}, {0, -1}};
    private Random random = new Random();
    @SideOnly(value=Side.CLIENT)
    IIcon iconBase;
    @SideOnly(value=Side.CLIENT)
    IIcon iconTrim;
    @SideOnly(value=Side.CLIENT)
    IIcon iconOverlayLeft;
    @SideOnly(value=Side.CLIENT)
    IIcon iconOverlayRight;

    public BlockFramingTable(String blockName) {
        super(Material.field_151575_d);
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c(blockName);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFramingTable();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        int priZ;
        int meta = world.func_72805_g(x, y, z);
        int priX = x + this.getXOff(meta);
        if (world.func_147439_a(priX, y, priZ = z + this.getZOff(meta)) != this || (world.func_72805_g(priX, y, priZ) & 8) != 0) {
            return false;
        }
        player.openGui((Object)StorageDrawers.instance, GuiHandler.framingGuiID, world, priX, y, priZ);
        return true;
    }

    private int getXOff(int meta) {
        if (BlockFramingTable.isRightBlock(meta)) {
            return 0;
        }
        return rightOffset[BlockFramingTable.getDirection(meta)][0];
    }

    private int getZOff(int meta) {
        if (BlockFramingTable.isRightBlock(meta)) {
            return 0;
        }
        return rightOffset[BlockFramingTable.getDirection(meta)][1];
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return StorageDrawers.proxy.framingTableRenderID;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        int side = BlockFramingTable.getDirection(meta);
        if (BlockFramingTable.isRightBlock(meta)) {
            if (world.func_147439_a(x + leftOffset[side][0], y, z + leftOffset[side][1]) != this) {
                world.func_147468_f(x, y, z);
                if (!world.field_72995_K) {
                    this.func_149697_b(world, x, y, z, 1, 0);
                }
            }
        } else if (world.func_147439_a(x + rightOffset[side][0], y, z + rightOffset[side][1]) != this) {
            world.func_147468_f(x, y, z);
        }
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return BlockFramingTable.isPrimaryBlock(meta) ? Item.func_150898_a((Block)ModBlocks.framingTable) : Item.func_150899_d((int)0);
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        if (BlockFramingTable.isPrimaryBlock(meta)) {
            super.func_149690_a(world, x, y, z, meta, chance, fortune);
        }
    }

    public int func_149656_h() {
        return 1;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        int side;
        if (player.field_71075_bZ.field_75098_d && !BlockFramingTable.isPrimaryBlock(meta) && world.func_147439_a(x += rightOffset[side = BlockFramingTable.getDirection(meta)][0], y, z += rightOffset[side][1]) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int side) {
        TileEntityFramingTable tile = (TileEntityFramingTable)world.func_147438_o(x, y, z);
        if (tile != null && BlockFramingTable.isPrimaryBlock(world.func_72805_g(x, y, z))) {
            int n = tile.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack stack = tile.func_70301_a(i);
                if (stack == null) continue;
                float fx = this.random.nextFloat() * 0.8f + 0.1f;
                float fy = this.random.nextFloat() * 0.8f + 0.1f;
                float fz = this.random.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int amount = this.random.nextInt(21) + 10;
                    if (amount > stack.field_77994_a) {
                        amount = stack.field_77994_a;
                    }
                    stack.field_77994_a -= amount;
                    EntityItem entity = new EntityItem(world, (double)((float)x + fx), (double)((float)y + fy), (double)((float)z + fz), new ItemStack(stack.func_77973_b(), amount, stack.func_77960_j()));
                    if (stack.func_77942_o()) {
                        entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    entity.field_70159_w = this.random.nextGaussian() * (double)0.05f;
                    entity.field_70181_x = this.random.nextGaussian() * (double)0.05f + (double)0.2f;
                    entity.field_70179_y = this.random.nextGaussian() * (double)0.05f;
                    world.func_72838_d((Entity)entity);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, side);
    }

    public static int getDirection(int meta) {
        return meta & 7;
    }

    public static boolean isRightBlock(int meta) {
        return (meta & 8) == 0;
    }

    public static boolean isPrimaryBlock(int meta) {
        return BlockFramingTable.isRightBlock(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconBase() {
        return this.iconBase;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim() {
        return this.iconTrim;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconOverlay(boolean left) {
        return left ? this.iconOverlayLeft : this.iconOverlayRight;
    }

    public void func_149651_a(IIconRegister register) {
        this.iconBase = register.func_94245_a("StorageDrawers:base/base_oak");
        this.iconTrim = register.func_94245_a("StorageDrawers:base/trim_oak");
        this.iconOverlayLeft = register.func_94245_a("StorageDrawers:overlay/shading_worktable_left");
        this.iconOverlayRight = register.func_94245_a("StorageDrawers:overlay/shading_worktable_right");
    }
}

