/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class NetQuestEdit {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:quest_edit");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetQuestEdit::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetQuestEdit::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendEdit(NBTTagCompound payload) {
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        MinecraftServer server = sender.field_71133_b;
        if (server == null) {
            return;
        }
        boolean isOP = server.func_71203_ab().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit quests without OP permissions!");
            sender.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        NBTTagCompound tag = message.func_76341_a();
        UUID senderID = QuestingAPI.getQuestingUUID((EntityPlayer)sender);
        int action = !message.func_76341_a().func_150297_b("action", 99) ? -1 : message.func_76341_a().func_74762_e("action");
        switch (action) {
            case 0: {
                NetQuestEdit.editQuests(tag.func_150295_c("data", 10));
                break;
            }
            case 1: {
                NetQuestEdit.deleteQuests(NBTConverter.UuidValueType.QUEST.readIds(tag, "questIDs"));
                break;
            }
            case 2: {
                NetQuestEdit.setQuestStates(NBTConverter.UuidValueType.QUEST.readIds(tag, "questIDs"), tag.func_74767_n("state"), senderID);
                break;
            }
            case 3: {
                NetQuestEdit.createQuests(tag.func_150295_c("data", 10));
                break;
            }
            default: {
                BetterQuesting.logger.log(Level.ERROR, "Invalid quest edit action '" + action + "'. Full payload:\n" + message.func_76341_a().toString());
            }
        }
    }

    public static void editQuests(NBTTagList data) {
        ArrayList<UUID> questIDs = new ArrayList<UUID>();
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound entry = data.func_150305_b(i);
            UUID questID = NBTConverter.UuidValueType.QUEST.readId(entry);
            questIDs.add(questID);
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.get(questID);
            if (quest == null) continue;
            quest.readFromNBT(entry.func_74775_l("config"));
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetQuestSync.sendSync(null, questIDs, true, false);
    }

    public static void deleteQuests(Collection<UUID> questIDs) {
        for (UUID uuid : questIDs) {
            QuestDatabase.INSTANCE.remove(uuid);
            QuestLineDatabase.INSTANCE.removeQuest(uuid);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("questIDs", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds(questIDs));
        payload.func_74768_a("action", 1);
        PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
    }

    public static void setQuestStates(Collection<UUID> questIDs, boolean state, UUID targetID) {
        Map questMap = QuestDatabase.INSTANCE.filterKeys(questIDs);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        EntityPlayerMP player = null;
        for (Object e : server.func_71203_ab().field_72404_b) {
            if (!((EntityPlayerMP)e).func_146103_bH().getId().equals(targetID)) continue;
            player = (EntityPlayerMP)e;
        }
        for (Map.Entry entry : questMap.entrySet()) {
            if (!state) {
                ((IQuest)entry.getValue()).resetUser(targetID, true);
                continue;
            }
            if (((IQuest)entry.getValue()).isComplete(targetID)) {
                ((IQuest)entry.getValue()).setClaimed(targetID, 0L);
            } else {
                ((IQuest)entry.getValue()).setComplete(targetID, 0L);
                int done = 0;
                if (!((IQuest)entry.getValue()).getProperty(NativeProps.LOGIC_TASK).getResult(done, ((IQuest)entry.getValue()).getTasks().size())) {
                    for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                        ((ITask)task.getValue()).setComplete(targetID);
                        if (!((IQuest)entry.getValue()).getProperty(NativeProps.LOGIC_TASK).getResult(++done, ((IQuest)entry.getValue()).getTasks().size())) continue;
                        break;
                    }
                }
            }
            if (player == null) continue;
            BetterQuesting.logger.info("{} ({}) completed quest {}", new Object[]{player.getDisplayName(), targetID, entry.getKey()});
        }
        SaveLoadHandler.INSTANCE.markDirty();
        if (player == null) {
            return;
        }
        NetQuestSync.sendSync(player, questIDs, false, true);
    }

    public static void createQuests(NBTTagList data) {
        ArrayList<UUID> questIDs = new ArrayList<UUID>();
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound entry = data.func_150305_b(i);
            UUID questID = NBTConverter.UuidValueType.QUEST.tryReadId(entry).orElseGet(QuestDatabase.INSTANCE::generateKey);
            questIDs.add(questID);
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.get(questID);
            if (quest == null) {
                quest = QuestDatabase.INSTANCE.createNew(questID);
            }
            if (!entry.func_150297_b("config", 10)) continue;
            quest.readFromNBT(entry.func_74775_l("config"));
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetQuestSync.sendSync(null, questIDs, true, false);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        int action;
        int n = action = !message.func_150297_b("action", 99) ? -1 : message.func_74762_e("action");
        if (action == 1) {
            for (UUID uuid : NBTConverter.UuidValueType.QUEST.readIds(message, "questIDs")) {
                QuestDatabase.INSTANCE.remove(uuid);
                QuestLineDatabase.INSTANCE.removeQuest(uuid);
            }
            MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
        }
    }

    public static void log(String msg) {
        BetterQuesting.logger.log(Level.INFO, msg);
    }
}

