/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.text;

import com.github.lunatrius.ingameinfo.parser.text.Location;
import java.util.EnumSet;
import java.util.Locale;
import java.util.regex.Pattern;

public class Token {
    private final String lexem;
    private final Location locationStart;
    private final Location locationEnd;
    private final TokenType type;

    public Token(String lexem, Location start, Location end, TokenType type) {
        this.lexem = lexem;
        this.locationStart = start;
        this.locationEnd = end;
        this.type = type;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s, %s, %s, %s, %s", new Object[]{this.lexem.replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t"), this.type, this.locationStart, this.locationEnd, this.isEof()});
    }

    public String getLexem() {
        return this.lexem;
    }

    public TokenType getType() {
        return this.type;
    }

    public boolean isEof() {
        return this.type.equals((Object)TokenType.EOF);
    }

    public static enum TokenType {
        EOF("$"),
        FUNC_HEAD("<"),
        FUNC_TAIL(">"),
        ARGS_HEAD("\\["),
        ARGS_SEPARATOR("/"),
        ARGS_TAIL("\\]"),
        NEWLINE("\\n+"),
        STRING("(\\\\[<>\\[/\\]\\\\]|[^<>\\[/\\]\\n])+");

        public static final EnumSet<TokenType> EXCEPTIONS;
        private final Pattern pattern;

        private TokenType(String regex) {
            this.pattern = Pattern.compile("^" + regex);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        static {
            EXCEPTIONS = EnumSet.of(FUNC_TAIL, ARGS_HEAD, ARGS_SEPARATOR, ARGS_TAIL);
        }
    }
}

