/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketItemConduitFilter
extends AbstractConduitPacket<IItemConduit>
implements IMessageHandler<PacketItemConduitFilter, IMessage> {
    private ForgeDirection dir;
    private boolean loopMode;
    private boolean roundRobin;
    private DyeColor colIn;
    private DyeColor colOut;
    private int priority;
    private IItemFilter inputFilter;
    private IItemFilter outputFilter;

    public PacketItemConduitFilter() {
    }

    public PacketItemConduitFilter(IItemConduit con, ForgeDirection dir) {
        super(con.getBundle().getEntity(), ConTypeEnum.ITEM);
        this.dir = dir;
        this.loopMode = con.isSelfFeedEnabled(dir);
        this.roundRobin = con.isRoundRobinEnabled(dir);
        this.colIn = con.getInputColor(dir);
        this.colOut = con.getOutputColor(dir);
        this.priority = con.getOutputPriority(dir);
        this.inputFilter = con.getInputFilter(dir);
        this.outputFilter = con.getOutputFilter(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeBoolean(this.loopMode);
        buf.writeBoolean(this.roundRobin);
        buf.writeInt(this.priority);
        buf.writeShort(this.colIn.ordinal());
        buf.writeShort(this.colOut.ordinal());
        FilterRegister.writeFilter(buf, this.inputFilter);
        FilterRegister.writeFilter(buf, this.outputFilter);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readShort()];
        this.loopMode = buf.readBoolean();
        this.roundRobin = buf.readBoolean();
        this.priority = buf.readInt();
        this.colIn = DyeColor.values()[buf.readShort()];
        this.colOut = DyeColor.values()[buf.readShort()];
        this.inputFilter = FilterRegister.readFilter(buf);
        this.outputFilter = FilterRegister.readFilter(buf);
    }

    public IMessage onMessage(PacketItemConduitFilter message, MessageContext ctx) {
        if (PacketItemConduitFilter.isInvalidPacketForGui(message, ctx)) {
            return null;
        }
        IItemConduit conduit = (IItemConduit)message.getTileCasted(ctx);
        conduit.setSelfFeedEnabled(message.dir, message.loopMode);
        conduit.setRoundRobinEnabled(message.dir, message.roundRobin);
        conduit.setInputColor(message.dir, message.colIn);
        conduit.setOutputColor(message.dir, message.colOut);
        conduit.setOutputPriority(message.dir, message.priority);
        this.applyFilter(message.dir, conduit, message.inputFilter, true);
        this.applyFilter(message.dir, conduit, message.outputFilter, false);
        message.getWorld(ctx).func_147471_g(message.x, message.y, message.z);
        return null;
    }

    private void applyFilter(ForgeDirection dir, IItemConduit conduit, IItemFilter filter, boolean isInput) {
        if (isInput) {
            conduit.setInputFilter(dir, filter);
        } else {
            conduit.setOutputFilter(dir, filter);
        }
    }
}

