/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import stevesaddons.components.WideNumberBox;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.interfaces.GuiManager;

public class WideNumberBoxList {
    private List<WideNumberBox> textBoxes = new ArrayList<WideNumberBox>();
    private WideNumberBox selectedTextBox;

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        for (WideNumberBox textBox : this.textBoxes) {
            if (!textBox.isVisible()) continue;
            int srcTextBoxY = ((Object)((Object)textBox)).equals((Object)this.selectedTextBox) ? 177 : 165;
            gui.drawTexture(textBox.getX(), textBox.getY(), 0, srcTextBoxY, textBox.getWidth(), 12);
            String str = String.valueOf(textBox.getNumber());
            gui.drawString(str, textBox.getX(), textBox.getY() + textBox.getTextY(), textBox.getTextSize(), 0xFFFFFF);
        }
    }

    public void onClick(int mX, int mY, int button) {
        for (WideNumberBox textBox : this.textBoxes) {
            if (!textBox.isVisible() || !CollisionHelper.inBounds((int)textBox.getX(), (int)textBox.getY(), (int)textBox.getWidth(), (int)12, (int)mX, (int)mY)) continue;
            if (((Object)((Object)textBox)).equals((Object)this.selectedTextBox)) {
                if (button == 0) {
                    this.selectedTextBox = null;
                    break;
                }
                textBox.setNumber(0);
                this.selectedTextBox.onNumberChanged();
                break;
            }
            this.selectedTextBox = textBox;
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.selectedTextBox != null && this.selectedTextBox.isVisible()) {
            if (Character.isDigit(c)) {
                int i = Integer.parseInt(String.valueOf(c));
                if ((double)Math.abs(this.selectedTextBox.getNumber()) < Math.pow(10.0, this.selectedTextBox.getLength() - 1)) {
                    this.selectedTextBox.setNumber(Math.min(this.selectedTextBox.getNumber() * 10 + i, this.selectedTextBox.getMaxNumber()));
                    this.selectedTextBox.onNumberChanged();
                }
                return true;
            }
            if (c == '-' && this.selectedTextBox.allowNegative()) {
                this.selectedTextBox.setNumber(this.selectedTextBox.getNumber() * -1);
                this.selectedTextBox.onNumberChanged();
            } else {
                if (k == 14) {
                    this.selectedTextBox.setNumber(this.selectedTextBox.getNumber() / 10);
                    this.selectedTextBox.onNumberChanged();
                    return true;
                }
                if (k == 15) {
                    for (int i = 0; i < this.textBoxes.size(); ++i) {
                        WideNumberBox textBox = this.textBoxes.get(i);
                        if (!((Object)((Object)textBox)).equals((Object)this.selectedTextBox)) continue;
                        int nextId = (i + 1) % this.textBoxes.size();
                        this.selectedTextBox = this.textBoxes.get(nextId);
                        break;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void addTextBox(WideNumberBox textBox) {
        this.textBoxes.add(textBox);
    }

    public WideNumberBox getTextBox(int id) {
        return this.textBoxes.get(id);
    }
}

