/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.items.sigil.holding;

import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import com.arc.bloodarsenal.common.BloodArsenal;
import com.arc.bloodarsenal.common.items.sigil.holding.InventoryAugmentedHolding;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SigilAugmentedHolding
extends EnergyItems {
    private static int invSize = 8;
    private static final String NBT_CURRENT_SIGIL = "CurrentSigil";

    public SigilAugmentedHolding() {
        this.func_77625_d(1);
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack.func_77978_p() != null) {
            ItemStack[] inv = SigilAugmentedHolding.getInternalInventory(stack);
            if (inv == null) {
                return this.field_77791_bV;
            }
            ItemStack item = SigilAugmentedHolding.getCurrentSigil(stack);
            if (item != null) {
                return item.func_77954_c();
            }
        }
        return this.field_77791_bV;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.augmentedHolding"));
        if (par1ItemStack.func_77978_p() != null) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
            ItemStack[] inv = SigilAugmentedHolding.getInternalInventory(par1ItemStack);
            if (inv == null) {
                return;
            }
            int currentSlot = SigilAugmentedHolding.getCurrentItem(par1ItemStack);
            ItemStack item = inv[currentSlot];
            if (item != null) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.item.currentitem") + " " + item.func_82833_r());
            }
            for (int i = 0; i <= invSize; ++i) {
                if (inv[i] == null) continue;
                par3List.add(StatCollector.func_74838_a((String)"tooltip.item.iteminslot") + " " + (i + 1) + ": " + inv[i].func_82833_r());
            }
        }
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        if (SigilAugmentedHolding.checkAndSetItemOwner((ItemStack)par1ItemStack, (EntityPlayer)par2EntityPlayer)) {
            int currentSlot = SigilAugmentedHolding.getCurrentItem(par1ItemStack);
            ItemStack[] inv = SigilAugmentedHolding.getInternalInventory(par1ItemStack);
            if (inv == null) {
                return false;
            }
            ItemStack itemUsed = inv[currentSlot];
            if (itemUsed == null) {
                return false;
            }
            boolean bool = itemUsed.func_77973_b().func_77648_a(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
            this.saveInventory(par1ItemStack, inv);
            return bool;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (SigilAugmentedHolding.checkAndSetItemOwner((ItemStack)par1ItemStack, (EntityPlayer)par3EntityPlayer)) {
            if (par3EntityPlayer.func_70093_af()) {
                InventoryAugmentedHolding.setUUID(par1ItemStack);
                par3EntityPlayer.openGui((Object)BloodArsenal.instance, 0, par3EntityPlayer.field_70170_p, (int)par3EntityPlayer.field_70165_t, (int)par3EntityPlayer.field_70163_u, (int)par3EntityPlayer.field_70161_v);
                return par1ItemStack;
            }
            int currentSlot = SigilAugmentedHolding.getCurrentItem(par1ItemStack);
            ItemStack[] inv = SigilAugmentedHolding.getInternalInventory(par1ItemStack);
            if (inv == null) {
                return par1ItemStack;
            }
            ItemStack itemUsed = inv[currentSlot];
            if (itemUsed == null) {
                return par1ItemStack;
            }
            itemUsed.func_77973_b().func_77659_a(itemUsed, par2World, par3EntityPlayer);
            this.saveInventory(par1ItemStack, inv);
        }
        return par1ItemStack;
    }

    public static int next(int mode) {
        int index = mode + 1;
        if (index >= invSize + 1) {
            index = 0;
        }
        return index;
    }

    public static int prev(int mode) {
        int index = mode - 1;
        if (index < 0) {
            index = invSize;
        }
        return index;
    }

    private static void initModeTag(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
            itemStack.field_77990_d.func_74768_a(NBT_CURRENT_SIGIL, invSize);
        }
    }

    public static ItemStack getCurrentSigil(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof SigilAugmentedHolding) {
            ItemStack[] itemStacks = SigilAugmentedHolding.getInternalInventory(itemStack);
            int currentSlot = SigilAugmentedHolding.getCurrentItem(itemStack);
            if (itemStacks != null) {
                return itemStacks[currentSlot];
            }
        }
        return null;
    }

    public static int getCurrentItem(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof SigilAugmentedHolding) {
            SigilAugmentedHolding.initModeTag(itemStack);
            int currentSigil = itemStack.field_77990_d.func_74762_e(NBT_CURRENT_SIGIL);
            currentSigil = MathHelper.func_76125_a((int)currentSigil, (int)0, (int)invSize);
            return currentSigil;
        }
        return 8;
    }

    public static ItemStack[] getInternalInventory(ItemStack itemStack) {
        SigilAugmentedHolding.initModeTag(itemStack);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        ItemStack[] inv = new ItemStack[9];
        NBTTagList tagList = tagCompound.func_150295_c(InventoryAugmentedHolding.NBT_ITEMS, 10);
        if (tagList == null) {
            return null;
        }
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot > invSize) continue;
            inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        return inv;
    }

    public void saveInventory(ItemStack itemStack, ItemStack[] inventory) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i <= invSize; ++i) {
            if (inventory[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        itemTag.func_74782_a(InventoryAugmentedHolding.NBT_ITEMS, (NBTBase)itemList);
    }

    public static void cycleSigil(ItemStack itemStack, int mode) {
        if (itemStack != null && itemStack.func_77973_b() instanceof SigilAugmentedHolding) {
            SigilAugmentedHolding.initModeTag(itemStack);
            itemStack.field_77990_d.func_74768_a(NBT_CURRENT_SIGIL, mode);
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par1ItemStack.func_77978_p() != null) {
            this.tickInternalInventory(par1ItemStack, par2World, par3Entity, par4, par5);
        }
    }

    public void tickInternalInventory(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        ItemStack[] inv = SigilAugmentedHolding.getInternalInventory(par1ItemStack);
        if (inv == null) {
            return;
        }
        for (int i = 0; i < invSize; ++i) {
            if (inv[i] == null) continue;
            inv[i].func_77973_b().func_77663_a(inv[i], par2World, par3Entity, par4, par5);
        }
    }
}

