/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import ru.timeconqueror.timecore.api.reflection.ReflectionHelper;

public class UnlockedMethod<T> {
    private final Method method;

    public UnlockedMethod(Method method) {
        this.method = method;
        ReflectionHelper.setAccessible(method);
    }

    public T invoke(Object methodOwner, Object ... params) {
        try {
            return (T)this.method.invoke(methodOwner, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isStatic() {
        return ReflectionHelper.isStatic(this.method);
    }

    public String toString() {
        return this.method.toString();
    }
}

