/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.registry.GameRegistry;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.model.PedestalTrophyModelHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class ItemTrophyModelHandler
extends PedestalTrophyModelHandler {
    public static final String ID = "item";
    public static final String PROPERTY_REGISTRY_NAME = "registryName";
    public static final String PROPERTY_META = "meta";
    public static final String PROPERTY_NBT = "nbt";
    public static final String PROPERTY_X_OFFSET = "xOffset";
    public static final String PROPERTY_Y_OFFSET = "yOffset";
    public static final String PROPERTY_Z_OFFSET = "zOffset";
    public static final String PROPERTY_YAW_OFFSET = "yawOffset";
    public static final String PROPERTY_SCALE = "scale";
    private static final Render RENDER = new Render();
    private EntityItem item;
    private double xOffset = 0.0;
    private double yOffset = Double.NaN;
    private double zOffset = 0.0;
    private float yawOffset = 0.0f;
    private float scale = Float.NaN;

    public ItemTrophyModelHandler() {
    }

    public ItemTrophyModelHandler(ItemStack item) {
        this.setItem(item);
        this.calculateScaleAndYOffset(item.func_77973_b());
    }

    public ItemTrophyModelHandler(ItemStack item, float yawOffset) {
        this(item);
        this.yawOffset = yawOffset;
    }

    @Override
    public void parse(String id, JsonObject json) throws JsonSyntaxException {
        String registryName = ConfigHandler.getStringProperty(json, PROPERTY_REGISTRY_NAME);
        int meta = ConfigHandler.getIntegerProperty(json, PROPERTY_META, 0);
        if (meta < 0 || meta > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal meta value (" + meta + ")!");
        }
        String nbt = ConfigHandler.getStringProperty(json, PROPERTY_NBT, null);
        ItemStack stack = GameRegistry.makeItemStack((String)registryName, (int)meta, (int)0, (String)nbt);
        if (stack == null) {
            throw new IllegalArgumentException("Could not find item " + registryName + "!");
        }
        this.xOffset = ConfigHandler.getDoubleProperty(json, PROPERTY_Y_OFFSET, this.xOffset);
        this.yOffset = ConfigHandler.getDoubleProperty(json, PROPERTY_Y_OFFSET, this.yOffset);
        this.zOffset = ConfigHandler.getDoubleProperty(json, PROPERTY_Y_OFFSET, this.zOffset);
        this.yawOffset = ConfigHandler.getFloatProperty(json, PROPERTY_YAW_OFFSET, this.yawOffset);
        this.scale = ConfigHandler.getFloatProperty(json, PROPERTY_SCALE, this.scale);
        this.setItem(stack);
        this.calculateScaleAndYOffset(stack.func_77973_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(double x, double y, double z, int rotation, @Nullable String name, long time, float partialTickTime) {
        super.render(x, y, z, rotation, name, time, partialTickTime);
        if (RENDER.func_76983_a() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)(x + this.xOffset), (double)(y + this.yOffset), (double)(z + this.zOffset));
        GL11.glRotatef((float)(22.5f * (float)rotation + this.yawOffset), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GL11.glPushAttrib((int)1048575);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        EntityItem entityItem = this.item;
        synchronized (entityItem) {
            try {
                this.item.func_70029_a((World)Minecraft.func_71410_x().field_71441_e);
                RENDER.func_76986_a(this.item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            finally {
                this.item.func_70029_a(null);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void setItem(ItemStack item) {
        this.item = new EntityItem(null);
        this.item.func_92058_a(item);
        this.item.field_70290_d = 0.0f;
    }

    private void calculateScaleAndYOffset(Item item) {
        if (Float.isNaN(this.scale)) {
            float f = this.scale = item instanceof ItemBlock ? 1.375f : 0.6875f;
        }
        if (Double.isNaN(this.yOffset)) {
            this.yOffset = (double)this.scale * 0.125 - 0.1875;
        }
    }

    private static class Render
    extends RenderItem {
        public Render() {
            this.func_76976_a(RenderManager.field_78727_a);
        }

        public void func_76986_a(EntityItem entityItem, double x, double y, double z, float p_76986_8_, float partialTickTime) {
            ItemStack stack = entityItem.func_92059_d();
            this.func_110777_b((Entity)entityItem);
            TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
            this.field_77025_h.setSeed(187L);
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            if (!ForgeHooksClient.renderEntityItem((EntityItem)entityItem, (ItemStack)stack, (float)0.0f, (float)0.0f, (Random)this.field_77025_h, (TextureManager)this.field_76990_c.field_78724_e, (RenderBlocks)this.field_147909_c, (int)1)) {
                if (stack.func_94608_d() == 0 && stack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)stack.func_77973_b()).func_149645_b())) {
                    float scale;
                    Block block = Block.func_149634_a((Item)stack.func_77973_b());
                    int renderType = block.func_149645_b();
                    float f = scale = renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2 ? 0.5f : 0.25f;
                    if (block.func_149701_w() > 0) {
                        GL11.glAlphaFunc((int)516, (float)0.1f);
                        GL11.glEnable((int)3042);
                        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    }
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    GL11.glPushMatrix();
                    this.field_147913_i.func_147800_a(block, stack.func_77960_j(), 1.0f);
                    GL11.glPopMatrix();
                    if (block.func_149701_w() > 0) {
                        GL11.glDisable((int)3042);
                    }
                } else if (stack.func_77973_b().func_77623_v()) {
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    for (int pass = 0; pass < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++pass) {
                        this.field_77025_h.setSeed(187L);
                        int color = stack.func_77973_b().func_82790_a(stack, pass);
                        float r = (float)(color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(color & 0xFF) / 255.0f;
                        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                        this.renderDroppedItem(entityItem, stack.func_77973_b().getIcon(stack, pass), 1, partialTickTime, r, g, b, pass);
                    }
                } else {
                    if (stack.func_77973_b() instanceof ItemCloth) {
                        GL11.glAlphaFunc((int)516, (float)0.1f);
                        GL11.glEnable((int)3042);
                        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    }
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    int color = stack.func_77973_b().func_82790_a(stack, 0);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    this.renderDroppedItem(entityItem, stack.func_77954_c(), 1, partialTickTime, r, g, b, 0);
                    if (stack.func_77973_b() instanceof ItemCloth) {
                        GL11.glDisable((int)3042);
                    }
                }
            }
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            this.func_110777_b((Entity)entityItem);
            TextureUtil.func_147945_b();
        }

        private void renderDroppedItem(EntityItem entityItem, IIcon icon, int count, float partialTickTime, float r, float g, float b, int pass) {
            Tessellator tessellator = Tessellator.field_78398_a;
            if (icon == null) {
                TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
                ResourceLocation resourcelocation = texturemanager.func_130087_a(entityItem.func_92059_d().func_94608_d());
                icon = ((TextureMap)texturemanager.func_110581_b(resourcelocation)).func_110572_b("missingno");
            }
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            GL11.glPushMatrix();
            float f1 = 0.0625f;
            float f2 = 0.021875f;
            ItemStack itemstack = entityItem.func_92059_d();
            GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)(-0.5f * (f1 + f2)));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(f1 + f2));
            if (itemstack.func_94608_d() == 0) {
                this.func_110776_a(TextureMap.field_110575_b);
            } else {
                this.func_110776_a(TextureMap.field_110576_c);
            }
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)f1);
            if (itemstack.hasEffect(pass)) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                this.field_76990_c.field_78724_e.func_110577_a(field_110798_h);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                GL11.glColor4f((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
                float f3 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f3, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
                f3 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f3), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f1);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glPopMatrix();
        }
    }
}

