/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import makamys.coretweaks.CoreTweaks;

public class PrefixedFolderResourceAccelerator {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("coretweaks.debugPrefixedFolderResourceAccelerator", "false"));
    private Map<String, Boolean> directoryExists = new HashMap<String, Boolean>();
    private File home;

    public PrefixedFolderResourceAccelerator(File homeFolder) {
        this.home = homeFolder;
        this.directoryExists.put(homeFolder.getPath(), true);
    }

    private boolean directoryExists(File directory) {
        String path = directory.getPath();
        Boolean cached = this.directoryExists.get(path);
        if (cached != null) {
            return cached;
        }
        boolean exists = false;
        boolean parentExists = this.directoryExists(directory.getParentFile());
        if (parentExists) {
            exists = directory.isDirectory();
        }
        this.directoryExists.put(path, exists);
        return exists;
    }

    private boolean computeIsFile(File file) {
        if (this.directoryExists(file.getParentFile())) {
            return file.isFile();
        }
        return false;
    }

    public boolean isFile(File file) {
        if (!file.getPath().startsWith(this.home.getPath())) {
            throw new IllegalArgumentException("Argument must start with " + this.home.getPath());
        }
        boolean vanillaResult = false;
        if (DEBUG) {
            vanillaResult = file.isFile();
        }
        boolean result = this.computeIsFile(file);
        if (DEBUG && vanillaResult != result) {
            CoreTweaks.LOGGER.error("Mismatch detected in FolderResourcePack optimization! (path=" + file.getPath() + ", vanillaResult=" + vanillaResult + ", result=" + result + ") Please report the issue and disable the option (`fast_folder_resource_pack`) for now.");
        }
        return result;
    }
}

