/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.render.BCSimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderBlockComplex
extends BCSimpleBlockRenderingHandler {
    private static final int[] Y_ROTATE = new int[]{3, 0, 1, 2};

    public void renderInventoryBlock(Block block, int meta, int modelId, RenderBlocks renderer) {
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        BlockBuildCraft bcBlock = (BlockBuildCraft)block;
        int pass = 0;
        while (bcBlock.canRenderInPassBC(pass)) {
            this.renderPassInventory(pass, bcBlock, meta, renderer);
            ++pass;
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private void renderPassInventory(int pass, BlockBuildCraft block, int meta, RenderBlocks renderer) {
        if (block.isRotatable()) {
            renderer.field_147867_u = Y_ROTATE[block.getFrontSide(meta) - 2];
            renderer.field_147865_v = Y_ROTATE[block.getFrontSide(meta) - 2];
        }
        RenderUtils.drawBlockItem(renderer, Tessellator.field_78398_a, (Block)block, meta);
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
    }

    private void renderPassWorld(int pass, BlockBuildCraft block, int meta, RenderBlocks renderer, IBlockAccess world, int x, int y, int z) {
        if (block.isRotatable()) {
            renderer.field_147867_u = Y_ROTATE[block.getFrontSide(meta) - 2];
            renderer.field_147865_v = Y_ROTATE[block.getFrontSide(meta) - 2];
        }
        double pDouble = (double)(pass > 0 ? 1 : 0) / 512.0;
        renderer.func_147782_a(block.func_149704_x() - pDouble, block.func_149665_z() - pDouble, block.func_149706_B() - pDouble, block.func_149753_y() + pDouble, block.func_149669_A() + pDouble, block.func_149693_C() + pDouble);
        renderer.func_147784_q((Block)block, x, y, z);
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BlockBuildCraft bcBlock = (BlockBuildCraft)block;
        int meta = world.func_72805_g(x, y, z);
        int pass = bcBlock.getCurrentRenderPass();
        while (bcBlock.canRenderInPassBC(pass)) {
            this.renderPassWorld(pass, bcBlock, meta, renderer, world, x, y, z);
            ++pass;
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BuildCraftCore.complexBlockModel;
    }
}

