/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.api.RotationHandler;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ClientProvider {
    private static final RotationHandler rotationHandler = new RotationHandler(){

        @Override
        public boolean ignoreSlotId(int slotId) {
            return slotId == 4;
        }

        @Override
        public int rotateSlotId(int slotId, boolean counterClockwise) {
            if (!counterClockwise) {
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 5: {
                        return 8;
                    }
                    case 8: {
                        return 7;
                    }
                    case 7: {
                        return 6;
                    }
                    case 6: {
                        return 3;
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else {
                switch (slotId) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 6;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 8;
                    }
                    case 8: {
                        return 5;
                    }
                }
            }
            return 0;
        }
    };

    public PlayerControllerMP getController() {
        return Minecraft.func_71410_x().field_71442_b;
    }

    public boolean canBalance(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide();
    }

    public void balanceGrid(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id) {
        if (!this.canBalance(provider, entityPlayer, container, id)) {
            return;
        }
        ArrayListMultimap balanceSlots = ArrayListMultimap.create();
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            Slot slot = (Slot)container.field_75151_b.get(i);
            if (!slot.func_75216_d()) continue;
            ItemStack itemStack = slot.func_75211_c();
            balanceSlots.put((Object)(itemStack.func_77977_a() + "@" + itemStack.func_77960_j()), (Object)slot);
        }
        for (String key : balanceSlots.keySet()) {
            Collection slotList = balanceSlots.get((Object)key);
            int average = 0;
            for (Slot slot : slotList) {
                average += slot.func_75211_c().field_77994_a;
            }
            average = (int)Math.floor((float)average / (float)slotList.size());
            for (Slot slot : slotList) {
                if (!slot.func_75216_d() || slot.func_75211_c().field_77994_a <= average) continue;
                int mouseStackSize = slot.func_75211_c().field_77994_a;
                this.getController().func_78753_a(container.field_75152_c, slot.field_75222_d, 0, 0, entityPlayer);
                for (Slot otherSlot : slotList) {
                    int otherStackSize;
                    if (slot == otherSlot || !otherSlot.func_75216_d() || (otherStackSize = otherSlot.func_75211_c().field_77994_a) >= average) continue;
                    while (otherStackSize < average && mouseStackSize > average) {
                        this.getController().func_78753_a(container.field_75152_c, otherSlot.field_75222_d, 1, 0, entityPlayer);
                        --mouseStackSize;
                        ++otherStackSize;
                    }
                }
                this.getController().func_78753_a(container.field_75152_c, slot.field_75222_d, 0, 0, entityPlayer);
            }
        }
    }

    public void spreadGrid(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id) {
        boolean emptyBiggestSlot;
        do {
            ItemStack itemStack;
            Slot biggestSlot = null;
            int biggestSlotSize = 1;
            int start = provider.getCraftingGridStart(entityPlayer, container, id);
            int size = provider.getCraftingGridSize(entityPlayer, container, id);
            for (int i = start; i < start + size; ++i) {
                Slot slot = (Slot)container.field_75151_b.get(i);
                itemStack = slot.func_75211_c();
                if (itemStack == null || itemStack.field_77994_a <= biggestSlotSize) continue;
                biggestSlot = slot;
                biggestSlotSize = itemStack.field_77994_a;
            }
            if (biggestSlot == null) break;
            emptyBiggestSlot = false;
            this.getController().func_78753_a(container.field_75152_c, biggestSlot.field_75222_d, 0, 0, entityPlayer);
            for (int i = start; i < start + size; ++i) {
                itemStack = ((Slot)container.field_75151_b.get(i)).func_75211_c();
                if (itemStack != null) continue;
                if (biggestSlotSize > 1) {
                    this.getController().func_78753_a(container.field_75152_c, i, 1, 0, entityPlayer);
                    --biggestSlotSize;
                    continue;
                }
                emptyBiggestSlot = true;
            }
            this.getController().func_78753_a(container.field_75152_c, biggestSlot.field_75222_d, 0, 0, entityPlayer);
        } while (emptyBiggestSlot);
        this.balanceGrid(provider, entityPlayer, container, id);
    }

    public boolean canClear(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide();
    }

    public void clearGrid(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id, boolean forced) {
        if (!this.canClear(provider, entityPlayer, container, id)) {
            return;
        }
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            this.getController().func_78753_a(container.field_75152_c, i, 0, 1, entityPlayer);
            container.func_82846_b(entityPlayer, i);
            if (!forced || !((Slot)container.field_75151_b.get(i)).func_75216_d()) continue;
            this.getController().func_78753_a(container.field_75152_c, i, 0, 4, entityPlayer);
        }
    }

    public boolean canRotate(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide() && provider.getCraftingGridSize(entityPlayer, container, id) == 9;
    }

    public void rotateGrid(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id, boolean counterClockwise) {
        if (!this.canRotate(provider, entityPlayer, container, id)) {
            return;
        }
        if (!this.dropOffMouseStack(entityPlayer, container)) {
            return;
        }
        if (this.rotateGridWithBuffer(provider, entityPlayer, container, id, counterClockwise)) {
            return;
        }
        int startSlot = provider.getCraftingGridStart(entityPlayer, container, id);
        this.getController().func_78753_a(container.field_75152_c, startSlot, 0, 0, entityPlayer);
        int currentSlot = startSlot;
        do {
            currentSlot = startSlot + rotationHandler.rotateSlotId(currentSlot - startSlot, counterClockwise);
            this.getController().func_78753_a(container.field_75152_c, currentSlot, 0, 0, entityPlayer);
        } while (currentSlot != startSlot);
    }

    public boolean rotateGridWithBuffer(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id, boolean counterClockwise) {
        int startSlot;
        int emptyBuffer = 0;
        int[] bufferSlot = new int[2];
        for (Object obj : container.field_75151_b) {
            Slot slot = (Slot)obj;
            if (!(slot.field_75224_c instanceof InventoryPlayer) || slot.func_75216_d()) continue;
            bufferSlot[emptyBuffer] = slot.field_75222_d;
            if (++emptyBuffer < 2) continue;
            break;
        }
        if (emptyBuffer < 2) {
            return false;
        }
        emptyBuffer = 0;
        int currentSlot = startSlot = provider.getCraftingGridStart(entityPlayer, container, id);
        do {
            this.getController().func_78753_a(container.field_75152_c, currentSlot, 0, 0, entityPlayer);
            this.getController().func_78753_a(container.field_75152_c, bufferSlot[emptyBuffer], 0, 0, entityPlayer);
            emptyBuffer = (emptyBuffer + 1) % 2;
            this.getController().func_78753_a(container.field_75152_c, bufferSlot[emptyBuffer], 0, 0, entityPlayer);
            this.getController().func_78753_a(container.field_75152_c, currentSlot, 0, 0, entityPlayer);
        } while ((currentSlot = startSlot + rotationHandler.rotateSlotId(currentSlot - startSlot, counterClockwise)) != startSlot);
        emptyBuffer = (emptyBuffer + 1) % 2;
        this.getController().func_78753_a(container.field_75152_c, bufferSlot[emptyBuffer], 0, 0, entityPlayer);
        this.getController().func_78753_a(container.field_75152_c, startSlot, 0, 0, entityPlayer);
        return true;
    }

    public boolean canTransfer(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide();
    }

    public boolean transferIntoGrid(TweakProvider provider, EntityPlayer entityPlayer, Container container, int id, Slot sourceSlot) {
        if (!this.canTransfer(provider, entityPlayer, container, id)) {
            return false;
        }
        if (!(sourceSlot.func_75216_d() && sourceSlot.func_82869_a(entityPlayer) && provider.canTransferFrom(entityPlayer, container, id, sourceSlot))) {
            return false;
        }
        if (!this.dropOffMouseStack(entityPlayer, container)) {
            return false;
        }
        this.getController().func_78753_a(container.field_75152_c, sourceSlot.field_75222_d, 0, 0, entityPlayer);
        ItemStack mouseStack = entityPlayer.field_71071_by.func_70445_o();
        if (mouseStack == null) {
            return false;
        }
        boolean itemMoved = false;
        int firstEmptySlot = -1;
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            Slot craftSlot = (Slot)container.field_75151_b.get(i);
            ItemStack craftStack = craftSlot.func_75211_c();
            if (craftStack != null) {
                int spaceLeft;
                if (!craftStack.func_77969_a(mouseStack) || !ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)mouseStack) || (spaceLeft = Math.min(craftSlot.func_75219_a(), craftStack.func_77976_d()) - craftStack.field_77994_a) <= 0) continue;
                this.getController().func_78753_a(container.field_75152_c, craftSlot.field_75222_d, 0, 0, entityPlayer);
                mouseStack = entityPlayer.field_71071_by.func_70445_o();
                if (mouseStack != null) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot != -1) {
            this.getController().func_78753_a(container.field_75152_c, firstEmptySlot, 0, 0, entityPlayer);
            itemMoved = true;
        }
        if (entityPlayer.field_71071_by.func_70445_o() != null) {
            this.getController().func_78753_a(container.field_75152_c, sourceSlot.field_75222_d, 0, 0, entityPlayer);
        }
        this.dropOffMouseStack(entityPlayer, container);
        return itemMoved;
    }

    public boolean dropOffMouseStack(EntityPlayer entityPlayer, Container container) {
        return this.dropOffMouseStack(entityPlayer, container, -1);
    }

    public boolean dropOffMouseStack(EntityPlayer entityPlayer, Container container, int ignoreSlot) {
        if (entityPlayer.field_71071_by.func_70445_o() == null) {
            return true;
        }
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            if (i == ignoreSlot) continue;
            Slot slot = (Slot)container.field_75151_b.get(i);
            if (slot.field_75224_c != entityPlayer.field_71071_by) continue;
            ItemStack mouseItem = entityPlayer.field_71071_by.func_70445_o();
            ItemStack slotStack = slot.func_75211_c();
            if (slotStack == null) {
                this.getController().func_78753_a(container.field_75152_c, i, 0, 0, entityPlayer);
            } else if (mouseItem.func_77973_b() == slotStack.func_77973_b() && (!slotStack.func_77981_g() || slotStack.func_77960_j() == mouseItem.func_77960_j()) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseItem)) {
                this.getController().func_78753_a(container.field_75152_c, i, 0, 0, entityPlayer);
            }
            if (entityPlayer.field_71071_by.func_70445_o() != null) continue;
            return true;
        }
        return entityPlayer.field_71071_by.func_70445_o() == null;
    }

    public void decompress(TweakProvider provider, EntityPlayer entityPlayer, Container container, Slot mouseSlot, boolean decompressAll) {
        if (!mouseSlot.func_75216_d() || !this.canClear(provider, entityPlayer, container, 0)) {
            return;
        }
        this.clearGrid(provider, entityPlayer, container, 0, false);
        int start = provider.getCraftingGridStart(entityPlayer, container, 0);
        int size = provider.getCraftingGridSize(entityPlayer, container, 0);
        for (int i = start; i < start + size; ++i) {
            if (!((Slot)container.field_75151_b.get(i)).func_75216_d()) continue;
            return;
        }
        this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
        this.getController().func_78753_a(container.field_75152_c, start, 0, 0, entityPlayer);
        for (Object obj : container.field_75151_b) {
            Slot slot = (Slot)obj;
            if (!(slot instanceof SlotCrafting) || !slot.func_75216_d()) continue;
            this.getController().func_78753_a(container.field_75152_c, slot.field_75222_d, 0, decompressAll ? 1 : 0, entityPlayer);
            break;
        }
        this.dropOffMouseStack(entityPlayer, container, mouseSlot.field_75222_d);
        this.getController().func_78753_a(container.field_75152_c, start, 0, 0, entityPlayer);
        this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compress(TweakProvider provider, EntityPlayer entityPlayer, Container container, Slot mouseSlot, boolean compressAll) {
        int i;
        if (!mouseSlot.func_75216_d() || !this.canClear(provider, entityPlayer, container, 0)) {
            return;
        }
        this.clearGrid(provider, entityPlayer, container, 0, false);
        int start = provider.getCraftingGridStart(entityPlayer, container, 0);
        int size = provider.getCraftingGridSize(entityPlayer, container, 0);
        for (int i2 = start; i2 < start + size; ++i2) {
            if (!((Slot)container.field_75151_b.get(i2)).func_75216_d()) continue;
            return;
        }
        ItemStack mouseStack = mouseSlot.func_75211_c();
        if (size == 9 && mouseStack.field_77994_a >= 9) {
            ItemStack result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)new InventoryCraftingCompress(container, 3, mouseStack), entityPlayer.field_70170_p);
            if (result != null) {
                this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(0, 0), 5, entityPlayer);
                for (i = start; i < start + size; ++i) {
                    this.getController().func_78753_a(container.field_75152_c, i, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                }
                this.getController().func_78753_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(2, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
            } else {
                result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)new InventoryCraftingCompress(container, 2, mouseStack), entityPlayer.field_70170_p);
                if (result == null) return;
                this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(0, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, start, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, start + 1, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, start + 3, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, start + 4, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(2, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
            }
        } else if (size >= 4 && mouseStack.field_77994_a >= 4) {
            ItemStack result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)new InventoryCraftingCompress(container, 2, mouseStack), entityPlayer.field_70170_p);
            if (result == null) return;
            this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
            this.getController().func_78753_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(0, 0), 5, entityPlayer);
            if (size == 4) {
                for (i = start; i < start + size; ++i) {
                    this.getController().func_78753_a(container.field_75152_c, i, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                }
            } else {
                this.getController().func_78753_a(container.field_75152_c, start, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, start + 1, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, start + 3, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
                this.getController().func_78753_a(container.field_75152_c, start + 4, ClientProvider.getDragSplittingButton(1, 0), 5, entityPlayer);
            }
            this.getController().func_78753_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(2, 0), 5, entityPlayer);
            this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
        }
        for (Object obj : container.field_75151_b) {
            Slot slot = (Slot)obj;
            if (!(slot instanceof SlotCrafting) || !slot.func_75216_d()) continue;
            this.getController().func_78753_a(container.field_75152_c, slot.field_75222_d, 0, compressAll ? 1 : 0, entityPlayer);
            break;
        }
        this.dropOffMouseStack(entityPlayer, container, mouseSlot.field_75222_d);
        for (int i3 = start; i3 < start + size; ++i3) {
            if (!((Slot)container.field_75151_b.get(i3)).func_75216_d()) continue;
            this.getController().func_78753_a(container.field_75152_c, i3, 0, 0, entityPlayer);
            this.getController().func_78753_a(container.field_75152_c, mouseSlot.field_75222_d, 0, 0, entityPlayer);
        }
        this.dropOffMouseStack(entityPlayer, container);
    }

    private static int getDragSplittingButton(int id, int limit) {
        return id & 3 | (limit & 3) << 2;
    }
}

