/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.stack;

import com.creativemd.creativecore.common.utils.stack.IStackLoader;
import com.creativemd.creativecore.common.utils.stack.StackInfoBlock;
import com.creativemd.creativecore.common.utils.stack.StackInfoItem;
import com.creativemd.creativecore.common.utils.stack.StackInfoItemStack;
import com.creativemd.creativecore.common.utils.stack.StackInfoMaterial;
import com.creativemd.creativecore.common.utils.stack.StackInfoOre;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public abstract class StackInfo {
    public static ArrayList<IStackLoader> loaders = new ArrayList();
    public int stackSize;

    public static void registerLoader(IStackLoader loader) {
        loaders.add(loader);
    }

    public static StackInfo parseString(String input) {
        if (input == null) {
            return null;
        }
        try {
            for (int i = 0; i < loaders.size(); ++i) {
                StackInfo temp = loaders.get(i).getStackInfoFromString(input);
                if (temp == null) continue;
                return temp;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static StackInfo parseObject(Object stack) {
        if (stack == null) {
            return null;
        }
        if (stack instanceof StackInfo) {
            return (StackInfo)stack;
        }
        for (int i = 0; i < loaders.size(); ++i) {
            StackInfo temp = null;
            try {
                temp = loaders.get(i).getStackInfo(stack);
            }
            catch (Exception e) {
                temp = null;
            }
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public int indexOf(ArrayList<StackInfo> infos) {
        for (int i = 0; i < infos.size(); ++i) {
            if (!infos.get(i).equalsIgnoreSize(this)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object object) {
        return object instanceof StackInfo && ((StackInfo)object).stackSize == this.stackSize && this.equalsIgnoreSize(object);
    }

    public abstract boolean equalsIgnoreSize(Object var1);

    public StackInfo() {
        this(0);
    }

    public StackInfo(int stackSize) {
        if (stackSize < 0) {
            stackSize = 0;
        }
        if (stackSize > 64) {
            stackSize = 64;
        }
        this.stackSize = stackSize;
    }

    public static void registerDefaultLoaders() {
        StackInfo.registerLoader(new StackInfoItem(null));
        StackInfo.registerLoader(new StackInfoBlock(null));
        StackInfo.registerLoader(new StackInfoItemStack(null, false, 0));
        StackInfo.registerLoader(new StackInfoOre(""));
        StackInfo.registerLoader(new StackInfoMaterial(null));
    }

    public abstract String toString();

    public abstract String toTitle();

    protected abstract boolean isStackInstanceIgnoreSize(ItemStack var1);

    public boolean isInstanceIgnoreSize(ItemStack stack) {
        return this.isStackInstanceIgnoreSize(stack);
    }

    public int getAmount(ItemStack stack) {
        if (this.stackSize == 0) {
            return Integer.MAX_VALUE;
        }
        return stack.field_77994_a / this.stackSize;
    }

    public boolean isInstance(ItemStack stack) {
        return this.isInstanceIgnoreSize(stack) && this.stackSize <= stack.field_77994_a;
    }

    public boolean isInstance(StackInfo info) {
        if (this.isInstanceIgnoreSize(info) && this.stackSize < info.stackSize) {
            return false;
        }
        return false;
    }

    public abstract boolean isInstanceIgnoreSize(StackInfo var1);

    public abstract StackInfo copy();

    public ItemStack getItemStack() {
        return this.getItemStack(this.stackSize);
    }

    public abstract ItemStack getItemStack(int var1);
}

