/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.TextIcon;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class TooltipLines
extends AbstractList<String> {
    private final List<Object> elements;
    private final List<Line> lines = new ArrayList<Line>(8);
    private int lastElementIndex = 0;

    public TooltipLines(List<Object> elements) {
        this.elements = elements;
    }

    public void clearCache() {
        this.lines.clear();
        this.lastElementIndex = 0;
    }

    private void buildUntil(int index) {
        Line line;
        while (index >= this.lines.size() && (line = this.parseNext()) != null) {
            this.lines.add(line);
        }
    }

    private Line parseNext() {
        if (this.lastElementIndex >= this.elements.size()) {
            return null;
        }
        StringBuilder currentLine = new StringBuilder();
        int currentLength = 0;
        for (int i = this.lastElementIndex; i < this.elements.size(); ++i) {
            Object o = this.elements.get(i);
            ++currentLength;
            if (o == IKey.LINE_FEED) {
                Line line = new Line(currentLine.toString(), this.lastElementIndex, currentLength);
                this.lastElementIndex += currentLength;
                return line;
            }
            String s = null;
            if (o instanceof IKey) {
                IKey key = (IKey)o;
                s = key.get();
            } else if (o instanceof String) {
                String s1;
                s = s1 = (String)o;
            } else if (o instanceof TextIcon) {
                TextIcon ti = (TextIcon)o;
                s = ti.getText();
            }
            if (s == null) continue;
            currentLine.append(s);
        }
        if (currentLength > 0) {
            Line line = new Line(currentLine.toString(), this.lastElementIndex, currentLength);
            this.lastElementIndex += currentLength;
            return line;
        }
        return null;
    }

    @Override
    public String get(int index) {
        this.buildUntil(index);
        return this.lines.get(index).text;
    }

    @Override
    public int size() {
        this.buildUntil(Integer.MAX_VALUE);
        return this.lines.size();
    }

    @Override
    public String remove(int index) {
        this.buildUntil(index);
        Line line = this.lines.remove(index);
        if (line.length == 1) {
            this.elements.remove(line.index);
        } else {
            this.elements.subList(line.index, line.index + line.length).clear();
        }
        for (int i = index; i < this.lines.size(); ++i) {
            this.lines.get(i).index -= line.length;
        }
        this.lastElementIndex -= line.length;
        return line.text;
    }

    @Override
    public void add(int index, String s) {
        this.buildUntil(index);
        int elementIndex = index >= this.lines.size() ? this.lastElementIndex : this.lines.get(index).index;
        this.lines.add(index, new Line(s, elementIndex, 1));
        for (int i = index + 1; i < this.lines.size(); ++i) {
            this.lines.get(i).index++;
        }
        this.elements.add(elementIndex, s);
        ++this.lastElementIndex;
    }

    @Override
    public String set(int index, String element) {
        Line line = this.lines.get(index);
        if (line.length == 1) {
            this.elements.set(line.index, element);
            this.lines.set(index, new Line(element, line.index, line.length));
        } else {
            this.remove(index);
            this.add(index, element);
        }
        return line.text;
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.lines.clear();
        this.lastElementIndex = 0;
    }

    private static class Line {
        private final String text;
        private final int length;
        private int index;

        private Line(String text, int index, int length) {
            this.text = text;
            this.index = index;
            this.length = length;
        }
    }
}

