/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class TileThaumatoriumRendererVisitor
extends ClassVisitor {
    public TileThaumatoriumRendererVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("entityItem")) {
            return null;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("renderTileEntityAt".equals(name)) {
            return new RenderTileEntityAtVisitor(this.api, mv);
        }
        return mv;
    }

    private static class RenderTileEntityAtVisitor
    extends MethodVisitor {
        public RenderTileEntityAtVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 181 && name.equals("entityItem")) {
                TC4Transformer.log.trace("Converted PUTFIELD to ASTORE");
                this.visitVarInsn(58, 14);
                this.visitInsn(87);
            } else if (opcode == 180 && name.equals("entityItem")) {
                TC4Transformer.log.trace("Converted GETFIELD to ALOAD");
                this.visitInsn(87);
                this.visitVarInsn(25, 14);
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack, maxLocals + 1);
        }
    }
}

