/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.capes;

import galaxyspace.GalaxySpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.client.capes.GCCapesEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public class GSCapeLoader
implements Runnable {
    private static final ResourceLocation CAPE_BLUE = new ResourceLocation("galaxyspace:textures/capes/capeBlue.png");
    private static final ResourceLocation CAPE_BROWN = new ResourceLocation("galaxyspace:textures/capes/capeBrown.png");
    private static final ResourceLocation CAPE_CYAN = new ResourceLocation("galaxyspace:textures/capes/capeCyan.png");
    private static final ResourceLocation CAPE_DARK_GRAY = new ResourceLocation("galaxyspace:textures/capes/capeDarkGray.png");
    private static final ResourceLocation CAPE_DARK_GREEN = new ResourceLocation("galaxyspace:textures/capes/capeDarkGreen.png");
    private static final ResourceLocation CAPE_DEV = new ResourceLocation("galaxyspace:textures/capes/capeDev.png");
    private static final ResourceLocation CAPE_GRAYC = new ResourceLocation("galaxyspace:textures/capes/capeGrayC.png");
    private static final ResourceLocation CAPE_LIGHT_BLUE = new ResourceLocation("galaxyspace:textures/capes/capeLightBlue.png");
    private static final ResourceLocation CAPE_LIGHT_GRAY = new ResourceLocation("galaxyspace:textures/capes/capeLightGray.png");
    private static final ResourceLocation CAPE_LIME = new ResourceLocation("galaxyspace:textures/capes/capeLime.png");
    private static final ResourceLocation CAPE_MAGENTA = new ResourceLocation("galaxyspace:textures/capes/capeMagenta.png");
    private static final ResourceLocation CAPE_ORANGE = new ResourceLocation("galaxyspace:textures/capes/capeOrange.png");
    private static final ResourceLocation CAPE_PINK = new ResourceLocation("galaxyspace:textures/capes/capePink.png");
    private static final ResourceLocation CAPE_PURPLE = new ResourceLocation("galaxyspace:textures/capes/capePurple.png");
    private static final ResourceLocation CAPE_RED = new ResourceLocation("galaxyspace:textures/capes/capeRed.png");
    private static final ResourceLocation CAPE_YELLOW = new ResourceLocation("galaxyspace:textures/capes/capeYellow.png");

    @Override
    public void run() {
        Map<String, ResourceLocation> nameToCape = GSCapeLoader.loadNameToCapeMap();
        if (!nameToCape.isEmpty()) {
            Minecraft.func_71410_x().func_152343_a(() -> {
                MinecraftForge.EVENT_BUS.register((Object)new GCCapesEventHandler(nameToCape));
                return null;
            });
        }
    }

    private static Map<String, ResourceLocation> loadNameToCapeMap() {
        URLConnection connection;
        HashMap<String, ResourceLocation> nameToCape = new HashMap<String, ResourceLocation>();
        int timeout = 10000;
        try {
            connection = new URL("https://demigods.at.ua/capes.txt").openConnection();
        }
        catch (Exception e) {
            GalaxySpace.LOGGER.error("Error getting capes list", (Throwable)e);
            return nameToCape;
        }
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(":")) continue;
                int splitLocation = line.indexOf(":");
                String username = line.substring(0, splitLocation);
                String capeName = line.substring(splitLocation + 1);
                nameToCape.put(username, GSCapeLoader.capeFromString(capeName));
            }
        }
        catch (IOException e) {
            GalaxySpace.LOGGER.error("Error reading line", (Throwable)e);
        }
        return nameToCape;
    }

    private static ResourceLocation capeFromString(String capeName) {
        ResourceLocation resourceLocation;
        switch (capeName) {
            case "capeBrown": {
                resourceLocation = CAPE_BROWN;
                break;
            }
            case "capeCyan": {
                resourceLocation = CAPE_CYAN;
                break;
            }
            case "capeDarkGray": {
                resourceLocation = CAPE_DARK_GRAY;
                break;
            }
            case "capeDarkGreen": {
                resourceLocation = CAPE_DARK_GREEN;
                break;
            }
            case "capeDev": {
                resourceLocation = CAPE_DEV;
                break;
            }
            case "capeGrayC": {
                resourceLocation = CAPE_GRAYC;
                break;
            }
            case "capeLightBlue": {
                resourceLocation = CAPE_LIGHT_BLUE;
                break;
            }
            case "capeLightGray": {
                resourceLocation = CAPE_LIGHT_GRAY;
                break;
            }
            case "capeLime": {
                resourceLocation = CAPE_LIME;
                break;
            }
            case "capeMagenta": {
                resourceLocation = CAPE_MAGENTA;
                break;
            }
            case "capeOrange": {
                resourceLocation = CAPE_ORANGE;
                break;
            }
            case "capePink": {
                resourceLocation = CAPE_PINK;
                break;
            }
            case "capePurple": {
                resourceLocation = CAPE_PURPLE;
                break;
            }
            case "capeRed": {
                resourceLocation = CAPE_RED;
                break;
            }
            case "capeYellow": {
                resourceLocation = CAPE_YELLOW;
                break;
            }
            default: {
                resourceLocation = CAPE_BLUE;
            }
        }
        return resourceLocation;
    }
}

