/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.util.BlockPos;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import de.keridos.floodlights.util.RandomUtil;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGrowLight
extends TileEntityFLElectric {
    private long nextGrowTick = 0L;

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from.getOpposite().ordinal() == this.orientation.ordinal();
    }

    public void growSource(boolean remove) {
        int[] rotatedCoords = MathUtil.rotate(1, 0, 0, this.orientation);
        int x = this.field_145851_c + rotatedCoords[0];
        int y = this.field_145848_d + rotatedCoords[1];
        int z = this.field_145849_e + rotatedCoords[2];
        this.setLightChecked(x, y, z, remove);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsageGrowLight;
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                if (world.func_72820_D() > this.nextGrowTick) {
                    BlockPos blockPosTarget = new BlockPos(this.field_145851_c + this.orientation.offsetX * 2, this.field_145848_d + this.orientation.offsetY * 2, this.field_145849_e + this.orientation.offsetZ * 2);
                    BlockPos blockPosFront = new BlockPos(this.field_145851_c + this.orientation.offsetX, this.field_145848_d + this.orientation.offsetY, this.field_145849_e + this.orientation.offsetZ);
                    Block block = this.field_145850_b.func_147439_a(blockPosTarget.posX, blockPosTarget.posY, blockPosTarget.posZ);
                    Block blockFront = this.field_145850_b.func_147439_a(blockPosFront.posX, blockPosFront.posY, blockPosFront.posZ);
                    if (GeneralUtil.isBlockValidGrowable(block, world, blockPosTarget) && blockFront.isAir((IBlockAccess)world, blockPosFront.posX, blockPosFront.posY, blockPosFront.posZ)) {
                        ((IGrowable)block).func_149853_b(world, RandomUtil.random, blockPosTarget.posX, blockPosTarget.posY, blockPosTarget.posZ);
                    }
                    this.nextGrowTick = world.func_72820_D() + (long)RandomUtil.getRandomTickTimeoutFromFloatChance(ConfigHandler.chanceGrowLight);
                }
                if (this.update) {
                    if (this.mode == 0) {
                        this.growSource(true);
                        this.growSource(false);
                    }
                    world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.update = false;
                } else if (!this.wasActive) {
                    if (this.mode == 0) {
                        this.growSource(false);
                    }
                    world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.storageEU >= (double)realEnergyUsage / 8.0) {
                    this.storageEU -= (double)realEnergyUsage / 8.0;
                } else {
                    this.storage.modifyEnergyStored(-realEnergyUsage);
                }
                this.wasActive = true;
            } else if ((!this.active || this.storage.getEnergyStored() < realEnergyUsage && this.storageEU < (double)realEnergyUsage / 8.0) && this.wasActive) {
                if (this.mode == 0) {
                    this.growSource(true);
                }
                world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            if (this.mode == 0) {
                this.growSource(true);
            }
            int n = this.mode = this.mode == 1 ? 0 : this.mode + 1;
            if (this.active && (this.storage.getEnergyStored() >= ConfigHandler.energyUsage || this.storageEU >= (double)ConfigHandler.energyUsage / 8.0) && this.mode == 0) {
                this.growSource(false);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:growLightLighting" : "gui.floodlights:growLightDarkLight";
            player.func_145747_a((IChatComponent)new ChatComponentText(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

