/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers;

import gregtech.api.enums.ItemList;
import gregtech.common.items.ItemVolumetricFlask;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class VolumetricFlaskHelper {
    public static ItemStack getVolumetricFlask(int aAmount) {
        return ItemList.VOLUMETRIC_FLASK.get(aAmount, new Object[0]);
    }

    public static ItemStack getLargeVolumetricFlask(int aAmount) {
        return GregtechItemList.VOLUMETRIC_FLASK_8k.get(aAmount, new Object[0]);
    }

    public static ItemStack getGiganticVolumetricFlask(int aAmount) {
        return GregtechItemList.VOLUMETRIC_FLASK_32k.get(aAmount, new Object[0]);
    }

    public static ItemStack getKleinBottle(int aAmount) {
        return GregtechItemList.KLEIN_BOTTLE.get(aAmount, new Object[0]);
    }

    public static boolean isVolumetricFlask(ItemStack aStack) {
        return VolumetricFlaskHelper.isNormalVolumetricFlask(aStack) || VolumetricFlaskHelper.isLargeVolumetricFlask(aStack) || VolumetricFlaskHelper.isGiganticVolumetricFlask(aStack) || VolumetricFlaskHelper.isKleinBottle(aStack);
    }

    public static boolean isNormalVolumetricFlask(ItemStack aStack) {
        return aStack.func_77973_b() == ItemList.VOLUMETRIC_FLASK.getItem();
    }

    public static boolean isLargeVolumetricFlask(ItemStack aStack) {
        return GregtechItemList.VOLUMETRIC_FLASK_8k.getItem() == aStack.func_77973_b();
    }

    public static boolean isGiganticVolumetricFlask(ItemStack aStack) {
        return GregtechItemList.VOLUMETRIC_FLASK_32k.getItem() == aStack.func_77973_b();
    }

    public static boolean isKleinBottle(ItemStack aStack) {
        return GregtechItemList.KLEIN_BOTTLE.getItem() == aStack.func_77973_b();
    }

    public static int getMaxFlaskCapacity(ItemStack aStack) {
        Item aItem;
        if (aStack != null && (aItem = aStack.func_77973_b()) instanceof ItemVolumetricFlask) {
            return ((ItemVolumetricFlask)aItem).getMaxCapacity();
        }
        return 0;
    }

    public static boolean isFlaskEmpty(ItemStack aStack) {
        return VolumetricFlaskHelper.getFlaskFluid(aStack) == null;
    }

    public static FluidStack getFlaskFluid(ItemStack aStack) {
        NBTTagCompound nbt;
        if (aStack.func_77942_o() && (nbt = aStack.func_77978_p()).func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public static void setFluid(ItemStack stack, FluidStack fluidStack) {
        boolean removeFluid = fluidStack == null || fluidStack.amount <= 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            if (removeFluid) {
                return;
            }
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (removeFluid) {
            nbt.func_82580_o("Fluid");
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        } else {
            nbt.func_74782_a("Fluid", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    public static int getFlaskCapacity(ItemStack aStack) {
        NBTTagCompound nbt;
        int capacity = 1000;
        if (aStack.func_77942_o() && (nbt = aStack.func_77978_p()).func_150297_b("Capacity", 3)) {
            capacity = nbt.func_74762_e("Capacity");
        }
        return Math.min(VolumetricFlaskHelper.getMaxFlaskCapacity(aStack), capacity);
    }

    public static boolean setNewFlaskCapacity(ItemStack aStack, int aCapacity) {
        if (aStack == null || aCapacity <= 0) {
            return false;
        }
        aCapacity = Math.min(aCapacity, VolumetricFlaskHelper.getMaxFlaskCapacity(aStack));
        NBTTagCompound nbt = aStack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            aStack.func_77982_d(nbt);
        }
        nbt.func_74768_a("Capacity", aCapacity);
        return true;
    }

    public static int fillFlask(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidStack fluidStack = VolumetricFlaskHelper.getFlaskFluid(stack);
        if (fluidStack == null) {
            fluidStack = new FluidStack(resource, 0);
        } else if (!fluidStack.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(VolumetricFlaskHelper.getMaxFlaskCapacity(stack) - fluidStack.amount, resource.amount);
        if (doFill && amount > 0) {
            fluidStack.amount += amount;
            VolumetricFlaskHelper.setFluid(stack, fluidStack);
        }
        return amount;
    }

    public static Item generateNewFlask(String unlocalized, String english, int maxCapacity) {
        return new ItemVolumetricFlask(unlocalized, english, maxCapacity);
    }
}

