/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.common.loaders.ItemRegistry;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.common.recipes.CALImprintRecipe;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTNEIImprintHandler
extends ShapelessRecipeHandler {
    public String getOverlayIdentifier() {
        return "gt.recipe.cal-imprinting";
    }

    public String getRecipeTabName() {
        return this.getRecipeName();
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)this.getOverlayIdentifier());
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") || outputId.equals(this.getOverlayIdentifier())) {
            this.loadAllRecipes(null);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ItemStack circuit = CALImprintRecipe.getCircuitFromCAL(result);
        if (circuit != null) {
            this.loadRecipe(null, CALImprintRecipe.getImprintForCircuit(circuit));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (CALImprintRecipe.isCAL(ingredient) && CALImprintRecipe.getCircuitFromCAL(ingredient) == null) {
            this.loadAllRecipes(ingredient);
        }
        if (CALImprintRecipe.getCircuitFromImprint(ingredient) != null) {
            this.loadRecipe(null, ingredient);
        }
    }

    private void loadAllRecipes(@Nullable ItemStack cal) {
        HashSet<GTUtility.ItemId> addedImprints = new HashSet<GTUtility.ItemId>();
        for (GTRecipe recipe : BartWorksRecipeMaps.circuitAssemblyLineRecipes.getAllRecipes()) {
            ItemStack imprint = (ItemStack)recipe.mSpecialItems;
            ItemStack circuit = CALImprintRecipe.getCircuitFromImprint(imprint);
            if (imprint == null || circuit == null || !addedImprints.add(GTUtility.ItemId.create(circuit))) continue;
            this.loadRecipe(cal, imprint);
        }
    }

    private void loadRecipe(@Nullable ItemStack cal, @NotNull ItemStack imprint) {
        if (cal == null) {
            cal = ItemRegistry.cal;
        }
        this.arecipes.add(new ShapelessRecipeHandler.CachedShapelessRecipe((ShapelessRecipeHandler)this, new Object[]{GTUtility.copyAmount(1, cal), GTUtility.copyAmount(1, imprint)}, CALImprintRecipe.installImprint(GTUtility.copyAmount(1, cal), imprint)));
    }
}

