/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects.commands;

import gregtech.commands.GTBaseCommand;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.SpaceProjectWorldSavedData;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class SPMCommand
extends GTBaseCommand {
    private static final String RESET = "reset";
    private static final String UNLOCK = "unlock";
    private static final String UNLOCK_UPGRADE = "unlock_upgrade";
    private static final String LOCK = "lock";
    private static final String LIST = "list";
    private static final String ALL = "-all";
    private static final String AVAILABLE = "-available";
    private static final String UNLOCKED = "-unlocked";
    private static final String COPY = "copy";

    public String func_71517_b() {
        return "spm";
    }

    public int func_82362_a() {
        return 0;
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <subCommand>. Available subCommands: reset, unlock, lock, list, copy";
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length < 1) {
            this.sendHelpMessage(sender);
            return;
        }
        switch (arguments[0]) {
            case "reset": {
                if (!sender.func_70003_b(4, this.func_71517_b())) {
                    SPMCommand.sendChatToPlayer(sender, "You don't have the permissions to execute this command");
                    return;
                }
                this.processReset(sender, arguments.length >= 2 ? arguments[1] : sender.func_70005_c_());
                break;
            }
            case "unlock": {
                if (!sender.func_70003_b(4, this.func_71517_b())) {
                    SPMCommand.sendChatToPlayer(sender, "You don't have the permissions to execute this command");
                    return;
                }
                if (arguments.length < 3) {
                    SPMCommand.sendChatToPlayer(sender, "Not enough arguments. Needs to mention a project and a location");
                    return;
                }
                this.processUnlock(sender, arguments[1], arguments[2], arguments.length >= 4 ? arguments[3] : sender.func_70005_c_());
                break;
            }
            case "unlock_upgrade": {
                if (!sender.func_70003_b(4, this.func_71517_b())) {
                    SPMCommand.sendChatToPlayer(sender, "You don't have the permissions to execute this command");
                    return;
                }
                if (arguments.length < 4) {
                    SPMCommand.sendChatToPlayer(sender, "Not enough arguments. Needs to mention a project a location and an upgrade name");
                    return;
                }
                this.processUnlock(sender, arguments[1], arguments[2], arguments[3], arguments.length >= 5 ? arguments[4] : sender.func_70005_c_());
                break;
            }
            case "lock": {
                if (!sender.func_70003_b(4, this.func_71517_b())) {
                    SPMCommand.sendChatToPlayer(sender, "You don't have the permissions to execute this command");
                    return;
                }
                if (arguments.length < 3) {
                    SPMCommand.sendChatToPlayer(sender, "Not enough arguments. Needs to mention a project and a location");
                    return;
                }
                this.processLock(sender, arguments[1], arguments[2], arguments.length >= 4 ? arguments[3] : sender.func_70005_c_());
            }
            case "list": {
                if (arguments.length < 2) {
                    SPMCommand.sendChatToPlayer(sender, "No Argument for list subCommand. Usage /spm list -all, -available or -unlocked");
                    return;
                }
                this.processList(sender, arguments[1], arguments.length >= 3 ? arguments[2] : sender.func_70005_c_());
                break;
            }
            case "copy": {
                if (!sender.func_70003_b(4, this.func_71517_b())) {
                    SPMCommand.sendChatToPlayer(sender, "You don't have the permissions to execute this command");
                    return;
                }
                if (arguments.length < 3) {
                    SPMCommand.sendChatToPlayer(sender, "Not enough arguments. Needs to mention 2 players");
                    return;
                }
                this.processCopy(sender, arguments[1], arguments[2]);
            }
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] arguments) {
        ArrayList<String> autoComplete = new ArrayList<String>();
        String filter = arguments.length == 0 ? "" : arguments[0].trim();
        switch (arguments.length) {
            case 1: {
                autoComplete.addAll(Arrays.asList(this.getSubCommands()));
                break;
            }
            case 2: {
                filter = arguments[1].trim();
                if (arguments[0].equals(LIST)) {
                    autoComplete.addAll(Arrays.asList(this.getListArguments()));
                    break;
                }
                if (arguments[0].equals(COPY) || arguments[0].equals(RESET)) {
                    autoComplete.addAll(Arrays.asList(this.getPlayers()));
                    break;
                }
                autoComplete.addAll(Arrays.asList(this.getProjects()));
                break;
            }
            case 3: {
                filter = arguments[2].trim();
                if (arguments[1].equals(ALL)) break;
                if (arguments[0].equals(LIST)) {
                    autoComplete.addAll(Arrays.asList(this.getPlayers()));
                    break;
                }
                autoComplete.addAll(Arrays.asList(this.getLocations()));
                break;
            }
            case 4: {
                filter = arguments[3].trim();
                if (arguments[0].equals(UNLOCK_UPGRADE)) {
                    ISpaceProject project = SpaceProjectManager.getProject(arguments[2]);
                    if (project == null) break;
                    autoComplete.addAll(project.getAllUpgrades().stream().map(ISpaceProject.ISP_Upgrade::getUnlocalizedName).collect(Collectors.toList()));
                    break;
                }
                autoComplete.addAll(Arrays.asList(this.getPlayers()));
            }
        }
        String finalFilter = filter;
        return autoComplete.stream().filter(s -> finalFilter.isEmpty() || s.startsWith(finalFilter)).collect(Collectors.toList());
    }

    private String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    private String[] getLocations() {
        return SpaceProjectManager.getLocationNames().toArray(new String[0]);
    }

    private String[] getProjects() {
        return SpaceProjectManager.getProjectsMap().keySet().toArray(new String[0]);
    }

    private String[] getSubCommands() {
        return new String[]{RESET, COPY, UNLOCK, UNLOCK_UPGRADE, LOCK, LIST};
    }

    private String[] getListArguments() {
        return new String[]{ALL, AVAILABLE, UNLOCKED};
    }

    private void processReset(ICommandSender sender, String playerName) {
        UUID tID = SpaceProjectManager.getPlayerUUIDFromName(playerName);
        SpaceProjectManager.spaceTeamProjects.put(tID, null);
        SpaceProjectWorldSavedData.INSTANCE.func_76185_a();
        SPMCommand.sendChatToPlayer(sender, "Cleared away map");
    }

    private void processLock(ICommandSender sender, String projectName, String location, String playerName) {
        UUID tID = SpaceProjectManager.getPlayerUUIDFromName(playerName);
        SpaceProjectManager.addTeamProject(tID, SpaceProjectManager.getLocation(location), projectName, null);
        SPMCommand.sendChatToPlayer(sender, "Project locked");
    }

    private void processUnlock(ICommandSender sender, String projectName, String location, String playerName) {
        UUID tID = SpaceProjectManager.getPlayerUUIDFromName(playerName);
        ISpaceProject tProject = SpaceProjectManager.getTeamProjectOrCopy(tID, projectName, SpaceProjectManager.getLocation(location));
        if (tProject != null) {
            tProject.setProjectCurrentStage(tProject.getTotalStages());
            SpaceProjectManager.addTeamProject(tID, SpaceProjectManager.getLocation(location), projectName, tProject);
            SPMCommand.sendChatToPlayer(sender, "Project unlocked");
        } else {
            SPMCommand.sendChatToPlayer(sender, "Incorrect internal project name. Try again");
        }
    }

    private void processUnlock(ICommandSender sender, String projectName, String location, String upgradeName, String playerName) {
        UUID tID = SpaceProjectManager.getPlayerUUIDFromName(playerName);
        ISpaceProject tProject = SpaceProjectManager.getTeamProjectOrCopy(tID, projectName, SpaceProjectManager.getLocation(location));
        if (tProject != null) {
            ISpaceProject.ISP_Upgrade upgrade = tProject.getUpgrade(upgradeName);
            if (upgrade == null) {
                SPMCommand.sendChatToPlayer(sender, "Incorrect internal project upgrade name. Try again");
                return;
            }
            if (!tProject.isFinished()) {
                tProject.setProjectCurrentStage(tProject.getTotalStages());
                SpaceProjectManager.addTeamProject(tID, SpaceProjectManager.getLocation(location), projectName, tProject);
            }
            tProject.setBuiltUpgrade(upgrade);
            SPMCommand.sendChatToPlayer(sender, "Project Upgrade unlocked");
        } else {
            SPMCommand.sendChatToPlayer(sender, "Incorrect internal project name. Try again");
        }
    }

    private void processList(ICommandSender sender, String argument, String playerName) {
        UUID tID = SpaceProjectManager.getPlayerUUIDFromName(playerName);
        switch (argument) {
            case "-all": {
                for (String project : SpaceProjectManager.getProjectsMap().keySet()) {
                    SPMCommand.sendChatToPlayer(sender, project);
                }
                break;
            }
            case "-available": {
                for (ISpaceProject project : SpaceProjectManager.getAllProjects()) {
                    if (!project.meetsRequirements(tID, false)) continue;
                    SPMCommand.sendChatToPlayer(sender, project.getProjectName());
                }
                break;
            }
            case "-unlocked": {
                for (ISpaceProject project : SpaceProjectManager.getTeamSpaceProjects(tID)) {
                    SPMCommand.sendChatToPlayer(sender, project.getProjectName());
                }
                break;
            }
        }
    }

    private void processCopy(ICommandSender sender, String playerToCopyFrom, String playerCopyingTo) {
    }
}

