/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.modularui2;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.modularui2.CoverGuiData;
import gregtech.common.covers.Cover;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class CoverUIFactory
extends AbstractUIFactory<CoverGuiData> {
    public static final CoverUIFactory INSTANCE = new CoverUIFactory();

    private CoverUIFactory() {
        super("gregtech:cover");
    }

    public void open(EntityPlayerMP player, int coverID, ICoverable tile, ForgeDirection side) {
        if (player instanceof FakePlayer) {
            return;
        }
        CoverGuiData guiData = new CoverGuiData((EntityPlayer)player, coverID, tile.getXCoord(), tile.getYCoord(), tile.getZCoord(), side);
        GuiManager.open((UIFactory)this, (GuiData)guiData, (EntityPlayerMP)player);
    }

    @NotNull
    public IGuiHolder<CoverGuiData> getGuiHolder(CoverGuiData data) {
        TileEntity tile = data.getTileEntity();
        if (!(tile instanceof ICoverable)) {
            throw new RuntimeException(String.format("TileEntity at %s, %s, %s is not an instance of ICoverable!", tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
        }
        ICoverable coverable = (ICoverable)tile;
        Cover cover = coverable.getCoverAtSide(data.getSide());
        if (cover.getCoverID() != data.getCoverID()) {
            throw new RuntimeException(String.format("Cover at %s, %s, %s on side %s is not the expected kind! Expected %s, got %s", tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, data.getSide(), data.getCoverID(), cover.getCoverID()));
        }
        return cover;
    }

    public boolean canInteractWith(EntityPlayer player, CoverGuiData guiData) {
        ICoverable coverable;
        TileEntity tileEntity;
        return super.canInteractWith(player, (GuiData)guiData) && (tileEntity = guiData.getTileEntity()) instanceof ICoverable && (coverable = (ICoverable)tileEntity).getCoverAtSide(guiData.getSide()).getCoverID() == guiData.getCoverID() && guiData.getSquaredDistance((Entity)player) <= 64.0;
    }

    public void writeGuiData(CoverGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getCoverID());
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
        buffer.writeByte(guiData.getSide().ordinal());
    }

    @NotNull
    public CoverGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new CoverGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), ForgeDirection.getOrientation((int)buffer.readByte()));
    }
}

