/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.spell.simple.SpellTeleport;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class RitualEffectExpulsion
extends RitualEffect {
    public static final int virtusDrain = 10;
    public static final int potentiaDrain = 10;
    public static final int tennebraeDrain = 5;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            boolean hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false);
            boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, false);
            int teleportDistance = hasVirtus ? 300 : 100;
            int range = hasPotentia ? 50 : 25;
            List<EntityPlayer> playerList = SpellHelper.getPlayersInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, range, range);
            boolean flag = false;
            TileEntity tile = world.func_147438_o(x, y + 1, z);
            IInventory inventoryTile = null;
            if (tile instanceof IInventory) {
                inventoryTile = (IInventory)tile;
            }
            for (EntityPlayer entityplayer : playerList) {
                String playerString;
                if (entityplayer.field_71075_bZ.field_75098_d || (playerString = SpellHelper.getUsername(entityplayer)).equals(owner)) continue;
                if (inventoryTile != null) {
                    boolean test = false;
                    for (int i = 0; i < inventoryTile.func_70302_i_(); ++i) {
                        ItemStack stack = inventoryTile.func_70301_a(i);
                        if (stack == null || !(stack.func_77973_b() instanceof IBindable) || !IBindable.getOwnerName(stack).equals(playerString)) continue;
                        test = true;
                    }
                    if (test) continue;
                }
                flag = this.teleportRandomly((EntityLivingBase)entityplayer, teleportDistance) || flag;
            }
            if (flag) {
                if (hasVirtus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, true);
                }
                if (hasPotentia) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, true);
                }
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
            }
        }
        boolean hasTennebrae = this.canDrainReagent(ritualStone, ReagentRegistry.tenebraeReagent, 5, false);
        if (hasTennebrae && SoulNetworkHandler.canSyphonFromOnlyNetwork(owner, 1000)) {
            boolean hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false);
            boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, false);
            int teleportDistance = hasVirtus ? 300 : 100;
            int range = hasPotentia ? 50 : 25;
            List<EntityLivingBase> livingList = SpellHelper.getLivingEntitiesInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, range, range);
            boolean flag = false;
            for (EntityLivingBase livingEntity : livingList) {
                if (livingEntity instanceof EntityPlayer) continue;
                flag = this.teleportRandomly(livingEntity, teleportDistance) || flag;
            }
            if (flag) {
                if (hasVirtus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, true);
                }
                if (hasPotentia) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, true);
                }
                this.canDrainReagent(ritualStone, ReagentRegistry.tenebraeReagent, 5, true);
                SoulNetworkHandler.syphonFromNetwork(owner, 1000);
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostExpulsion[1];
    }

    public boolean teleportRandomly(EntityLivingBase entityLiving, double distance) {
        int i;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
        }
        double x = entityLiving.field_70165_t;
        double y = entityLiving.field_70163_u;
        double z = entityLiving.field_70161_v;
        Random rand = new Random();
        double d0 = x + (rand.nextDouble() - 0.5) * distance;
        double d1 = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
        double d2 = z + (rand.nextDouble() - 0.5) * distance;
        for (i = 0; !this.teleportTo(entityLiving, d0, d1, d2, x, y, z) && i < 100; ++i) {
            d0 = x + (rand.nextDouble() - 0.5) * distance;
            d1 = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
            d2 = z + (rand.nextDouble() - 0.5) * distance;
        }
        return i < 100;
    }

    public boolean teleportTo(EntityLivingBase entityLiving, double par1, double par3, double par5, double lastX, double lastY, double lastZ) {
        EnderTeleportEvent event = new EnderTeleportEvent(entityLiving, par1, par3, par5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = lastX;
        double d4 = lastY;
        double d5 = lastZ;
        SpellTeleport.moveEntityViaTeleport(entityLiving, event.targetX, event.targetY, event.targetZ);
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)entityLiving.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityLiving.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityLiving.field_70161_v);
        if (entityLiving.field_70170_p.func_72899_e(i, j, k)) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = entityLiving.field_70170_p.func_147439_a(i, j - 1, k);
                if (block != null && block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entityLiving.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                SpellTeleport.moveEntityViaTeleport(entityLiving, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                if (entityLiving.field_70170_p.func_72945_a((Entity)entityLiving, entityLiving.field_70121_D).isEmpty() && !entityLiving.field_70170_p.func_72953_d(entityLiving.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            SpellTeleport.moveEntityViaTeleport(entityLiving, d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f1 = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f2 = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entityLiving.field_70165_t - d3) * d6 + (entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            double d8 = d4 + (entityLiving.field_70163_u - d4) * d6 + entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)entityLiving.field_70131_O;
            double d9 = d5 + (entityLiving.field_70161_v - d5) * d6 + (entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            entityLiving.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        return true;
    }

    public void moveEntityViaTeleport(EntityLivingBase entityLiving, double x, double y, double z) {
        if (entityLiving instanceof EntityPlayer) {
            if (entityLiving != null && entityLiving instanceof EntityPlayerMP) {
                EnderTeleportEvent event;
                EntityPlayerMP entityplayermp = (EntityPlayerMP)entityLiving;
                if (entityplayermp.field_70170_p == entityLiving.field_70170_p && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)entityplayermp, x, y, z, 5.0f)))) {
                    if (entityLiving.func_70115_ae()) {
                        entityLiving.func_70078_a((Entity)null);
                    }
                    entityLiving.func_70634_a(event.targetX, event.targetY, event.targetZ);
                }
            }
        } else if (entityLiving != null) {
            entityLiving.func_70107_b(x, y, z);
        }
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> expulsionRitual = new ArrayList<RitualComponent>();
        expulsionRitual.add(new RitualComponent(2, 0, 2, 3));
        expulsionRitual.add(new RitualComponent(2, 0, 1, 3));
        expulsionRitual.add(new RitualComponent(1, 0, 2, 3));
        expulsionRitual.add(new RitualComponent(2, 0, -2, 3));
        expulsionRitual.add(new RitualComponent(2, 0, -1, 3));
        expulsionRitual.add(new RitualComponent(-1, 0, 2, 3));
        expulsionRitual.add(new RitualComponent(-2, 0, 2, 3));
        expulsionRitual.add(new RitualComponent(-2, 0, 1, 3));
        expulsionRitual.add(new RitualComponent(1, 0, -2, 3));
        expulsionRitual.add(new RitualComponent(-2, 0, -2, 3));
        expulsionRitual.add(new RitualComponent(-2, 0, -1, 3));
        expulsionRitual.add(new RitualComponent(-1, 0, -2, 3));
        expulsionRitual.add(new RitualComponent(4, 0, 2, 4));
        expulsionRitual.add(new RitualComponent(5, 0, 2, 4));
        expulsionRitual.add(new RitualComponent(4, 0, -2, 4));
        expulsionRitual.add(new RitualComponent(5, 0, -2, 4));
        expulsionRitual.add(new RitualComponent(-4, 0, 2, 4));
        expulsionRitual.add(new RitualComponent(-5, 0, 2, 4));
        expulsionRitual.add(new RitualComponent(-4, 0, -2, 4));
        expulsionRitual.add(new RitualComponent(-5, 0, -2, 4));
        expulsionRitual.add(new RitualComponent(2, 0, 4, 4));
        expulsionRitual.add(new RitualComponent(2, 0, 5, 4));
        expulsionRitual.add(new RitualComponent(-2, 0, 4, 4));
        expulsionRitual.add(new RitualComponent(-2, 0, 5, 4));
        expulsionRitual.add(new RitualComponent(2, 0, -4, 4));
        expulsionRitual.add(new RitualComponent(2, 0, -5, 4));
        expulsionRitual.add(new RitualComponent(-2, 0, -4, 4));
        expulsionRitual.add(new RitualComponent(-2, 0, -5, 4));
        expulsionRitual.add(new RitualComponent(0, 0, 6, 3));
        expulsionRitual.add(new RitualComponent(0, 0, -6, 3));
        expulsionRitual.add(new RitualComponent(6, 0, 0, 3));
        expulsionRitual.add(new RitualComponent(-6, 0, 0, 3));
        expulsionRitual.add(new RitualComponent(-5, 0, 0, 5));
        expulsionRitual.add(new RitualComponent(-6, 0, 1, 5));
        expulsionRitual.add(new RitualComponent(-6, 0, -1, 5));
        expulsionRitual.add(new RitualComponent(5, 0, 0, 5));
        expulsionRitual.add(new RitualComponent(6, 0, 1, 5));
        expulsionRitual.add(new RitualComponent(6, 0, -1, 5));
        expulsionRitual.add(new RitualComponent(0, 0, 5, 5));
        expulsionRitual.add(new RitualComponent(1, 0, 6, 5));
        expulsionRitual.add(new RitualComponent(-1, 0, 6, 5));
        expulsionRitual.add(new RitualComponent(0, 0, -5, 5));
        expulsionRitual.add(new RitualComponent(1, 0, -6, 5));
        expulsionRitual.add(new RitualComponent(-1, 0, -6, 5));
        expulsionRitual.add(new RitualComponent(4, 0, 4, 2));
        expulsionRitual.add(new RitualComponent(4, 0, -4, 2));
        expulsionRitual.add(new RitualComponent(-4, 0, 4, 2));
        expulsionRitual.add(new RitualComponent(-4, 0, -4, 2));
        return expulsionRitual;
    }
}

