/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

abstract class DSULikeInventoryHandler
extends SpecialInventoryHandler {
    protected boolean _hideOnePerStack;

    DSULikeInventoryHandler() {
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        if (this.isEmpty() || itemIdent.tag != null) {
            return 0;
        }
        return this.getTypeIdent().equals(itemIdent) ? this.getCurrent() : 0;
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        if (this.isEmpty()) {
            return null;
        }
        if (!this.getTypeIdent().equals(itemIdent)) {
            return null;
        }
        int current = this.getCurrent();
        int toTake = Math.max(Math.min(this._hideOnePerStack ? current - 1 : current, count), 0);
        this.setContent(current - toTake);
        this.markDirty();
        return itemIdent.makeNormalStack(toTake);
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        if (!this.isEmpty()) {
            result.add(this.getTypeIdent());
        }
        return result;
    }

    public HashMap<ItemIdentifier, Integer> getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        if (!this.isEmpty()) {
            result.put(this.getTypeIdent(), this.getReportedCount());
        }
        return result;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        return !this.isEmpty() && this.getTypeIdent().getUndamaged().equals(itemIdent);
    }

    int roomForItemNoTag(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return 0;
        }
        if (this.isEmpty()) {
            return this.getSize();
        }
        if (stack.func_77969_a(this.getType())) {
            return this.getSize() - this.getCurrent();
        }
        return 0;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        if (itemIdent.tag != null) {
            return 0;
        }
        if (this.isEmpty()) {
            return this.getSize();
        }
        if (this.getTypeIdent().equals(itemIdent)) {
            return this.getSize() - this.getCurrent();
        }
        return 0;
    }

    @Override
    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        if (stack.func_77978_p() != null) {
            return st;
        }
        st.field_77994_a = Math.min(this.roomForItemNoTag(stack), stack.field_77994_a);
        if (st.field_77994_a == 0) {
            return st;
        }
        if (doAdd) {
            if (this.isEmpty()) {
                this.setContent(st, st.field_77994_a);
            } else {
                this.setContent(this.getCurrent() + st.field_77994_a);
            }
            this.markDirty();
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if (i != 0 || this.isEmpty()) {
            return null;
        }
        ItemStack res = this.getType();
        res.field_77994_a = this.getReportedCount();
        return res;
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (i != 0 || this.isEmpty()) {
            return null;
        }
        return this.getMultipleItems(ItemIdentifier.get(this.getType()), j);
    }

    abstract boolean isEmpty();

    abstract int getSize();

    abstract int getCurrent();

    abstract ItemStack getType();

    ItemIdentifier getTypeIdent() {
        return ItemIdentifier.get(this.getType());
    }

    abstract void setContent(int var1);

    abstract void setContent(ItemStack var1, int var2);

    abstract void markDirty();

    int getReportedCount() {
        if (this._hideOnePerStack) {
            return Math.max(0, this.getCurrent() - 1);
        }
        return this.getCurrent();
    }
}

