/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.network.handlers;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api2.utils.Tuple2;
import bq_standard.core.BQ_Standard;
import bq_standard.network.handlers.NetLootSync;
import bq_standard.rewards.loot.LootRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class NetLootImport {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:loot_import");

    public static void registerHandler() {
        QuestingAPI.getAPI(ApiReference.PACKET_REG).registerServerHandler(ID_NAME, NetLootImport::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void importLoot(NBTTagCompound data) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)data);
        QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        NBTTagCompound tag = message.func_76341_a();
        if (sender.field_71133_b == null) {
            return;
        }
        if (!sender.field_71133_b.func_71203_ab().func_152596_g(sender.func_146103_bH())) {
            BQ_Standard.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to import loot without OP permissions!");
            sender.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to be OP to edit loot!"));
            return;
        }
        LootRegistry.INSTANCE.readFromNBT(tag.func_74775_l("data"), false);
        NetLootSync.sendSync(null);
    }
}

